package com.orocube.workspace.subscription;

import java.util.ArrayList;
import java.util.List;

public enum SubscriptionFeature {
	//@formatter:off
	OnlineOrdering("Online ordering"), //$NON-NLS-1$
	MenuProgrammingManual("Menu programming","Manual"), //$NON-NLS-1$
	MenuProgrammingPosSync("Menu programming","POS sync"), //$NON-NLS-1$
	POSIntegration("POS Integration"), //$NON-NLS-1$
	SectionalItemOrPizza("Sectional item/pizza"), //$NON-NLS-1$
	MultiOutlet("Multiple outlet"), //$NON-NLS-1$
	PrintToKitchen("Print to kitchen"), //$NON-NLS-1$
	PyamentProcessingCash("Payment processing","Cash"), //$NON-NLS-1$
	PaymentProcessingCashAndCard("Payment processing","Cash, Card"), //$NON-NLS-1$
	EmployeeStarter("Employee",1), //$NON-NLS-1$
	EmployeeLimited("Employee",5), //$NON-NLS-1$
	EmployeeUnlimited("Employee","Unlimited"), //$NON-NLS-1$
	AndroidAppLimited("Android app","Limited"), //$NON-NLS-1$
	AndroidAppFull("Android app","Full"), //$NON-NLS-1$
	TextNotificationLimited("Text notification",100), //$NON-NLS-1$
	TextNotificationUnlimited("Text notification","Unlimited"), //$NON-NLS-1$
	RealTimeOrderStatus("Real time order status"), //$NON-NLS-1$
	Support("Support"), //$NON-NLS-1$
	DataBackUp("Data backup"), 
	SetupAssistance("Setup assistance"), 
	Training("Training"), 
	TerminalLimited("No. of terminal",1),//$NON-NLS-1$
	Marketing("Marketing"), //$NON-NLS-1$
	NumberOfTicketsStarter("No. of ticket per day",50), //$NON-NLS-1$
	NumberOfTicketsLight("No. of ticket per day",200), //$NON-NLS-1$
	NumberOfTicketsMenugreatStarter("No. of ticket per day",10), //$NON-NLS-1$
	NumberOfTicketsUnlimited("No. of ticket per day","Unlimited"), //$NON-NLS-1$ //$NON-NLS-2$
	MultiTerminal("No. of terminal","Unlimited");//$NON-NLS-1$
	//@formatter:on

	private String label;
	private Object limit;

	private SubscriptionFeature(String label) {
		this.label = label;
	}

	private SubscriptionFeature(String label, Object limit) {
		this.label = label;
		this.limit = limit;
	}

	public String getLabel() {
		return label;
	}

	@Override
	public String toString() {
		return getLabel();
	}

	public static SubscriptionFeature get(String label) {
		for (SubscriptionFeature product : values()) {
			if (product.getLabel().equals(label)) {
				return product;
			}
		}
		return null;
	}

	public Object getLimit() {
		return limit;
	}

	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	public static List<SubscriptionFeature> distinctValues() {
		List<SubscriptionFeature> distinctValues = new ArrayList<>();
		for (SubscriptionFeature subscriptionFeature : values()) {
			if (subscriptionFeature.getLimit() != null && subscriptionFeature.getLimit() instanceof Integer) {
				continue;
			}
			distinctValues.add(subscriptionFeature);
		}
		return distinctValues;
	}
}
