/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;

import com.floreantpos.PosLog;
import com.floreantpos.model.ExpenseTransaction;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.PosTransactionDAO;

public class UpdateDBTo401 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo401(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void updateMemoNo() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$ //$NON-NLS-2$

		int totalExpense = rowCount();
		PosLog.info(UpdateDBTo401.class, "Found total expense: " + totalExpense); //$NON-NLS-1$

		int increment = 10;
		int count = 0;
		while (count < totalExpense) {
			try (Session session = sessionFactory.openSession()) {

				Transaction transaction = session.beginTransaction();
				Pagination<ExpenseTransaction> pagination = new Pagination<ExpenseTransaction>(count, increment);
				pagination.setNumRows(totalExpense);
				findExpenseTransaction(pagination, session);

				List<ExpenseTransaction> transactions = pagination.getDataList();
				for (PosTransaction posTransaction : transactions) {
					String propertyMemoNo = posTransaction.getProperty("memo_no", ""); //$NON-NLS-1$//$NON-NLS-2$
					if (StringUtils.isNotBlank(propertyMemoNo)) {
						posTransaction.setMemoNo(propertyMemoNo);
						PosTransactionDAO.getInstance().saveOrUpdate(posTransaction, session);
						PosLog.info(getClass(), "Updated memo_no from property to field: " + propertyMemoNo + ", transaction_id: " + posTransaction.getId()); //$NON-NLS-1$ //$NON-NLS-2$
					}
				}
				transaction.commit();

				count += increment;

			}

			PosLog.info(getClass(), schemaName + " update completed successfully"); //$NON-NLS-1$
		}
	}

	private void findExpenseTransaction(Pagination<ExpenseTransaction> pagination, Session session) {
		Criteria criteria = createExpenseCriteria(session);
		criteria.setFirstResult(pagination.getCurrentRowIndex());
		criteria.setMaxResults(pagination.getPageSize());
		pagination.setRows(criteria.list());

	}

	public int rowCount() {
		try (Session session = sessionFactory.openSession()) {
			Criteria criteria = createExpenseCriteria(session);
			criteria.setProjection(Projections.rowCount());
			return ((Long) criteria.uniqueResult()).intValue();
		}
	}

	private Criteria createExpenseCriteria(Session session) {
		Criteria criteria = session.createCriteria(ExpenseTransaction.class);
		return criteria;
	}
}