package com.floreantpos.model;

public enum OTApprovalStatus {
	//@formatter:off
		PENDING("Pending"), 
		APPROVED("Approved"), 
		REJECTED("Canceled")
		;
		//@formatter:on
	private String displayString;

	private OTApprovalStatus(String displayString) {
		this.displayString = displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static OTApprovalStatus fromNameString(String name) {
		OTApprovalStatus[] statusList = values();
		for (OTApprovalStatus status : statusList) {
			if (status.name().equals(name)) {
				return status;
			}
		}
		return PENDING;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

}
