package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the DOCTOR_VISIT_DIAGNOSIS_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DOCTOR_VISIT_DIAGNOSIS_ITEM"
 */

public abstract class BaseDoctorVisitDiagnosisItem  implements Comparable, Serializable {

	public static String REF = "DoctorVisitDiagnosisItem"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_TEST_ITEM_ID = "testItemId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_DOCTOR_VISIT = "doctorVisit"; //$NON-NLS-1$


	// constructors
	public BaseDoctorVisitDiagnosisItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDoctorVisitDiagnosisItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BaseDoctorVisitDiagnosisItem (
		java.lang.String id,
		com.floreantpos.model.DoctorVisit doctorVisit) {

		this.setId(id);
		this.setDoctorVisit(doctorVisit);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String testItemId;
				private java.lang.String status;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.DoctorVisit doctorVisit;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: TEST_ITEM_ID
	 */

	public java.lang.String getTestItemId () {
			return testItemId;
	}



	/**
	 * Set the value related to the column: TEST_ITEM_ID
	 * @param testItemId the TEST_ITEM_ID value
	 */
			public void setTestItemId (java.lang.String testItemId) {
			this.testItemId = testItemId;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DOCTOR_VISIT_ID
	 */

	public com.floreantpos.model.DoctorVisit getDoctorVisit () {
			return doctorVisit;
	}



	/**
	 * Set the value related to the column: DOCTOR_VISIT_ID
	 * @param doctorVisit the DOCTOR_VISIT_ID value
	 */
			public void setDoctorVisit (com.floreantpos.model.DoctorVisit doctorVisit) {
			this.doctorVisit = doctorVisit;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DoctorVisitDiagnosisItem)) return false;
		else {
			com.floreantpos.model.DoctorVisitDiagnosisItem doctorVisitDiagnosisItem = (com.floreantpos.model.DoctorVisitDiagnosisItem) obj;
			if (null == this.getId() || null == doctorVisitDiagnosisItem.getId()) return this == obj;
			else return (this.getId().equals(doctorVisitDiagnosisItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}