package com.floreantpos.report;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.dao.PayoutRecepientDAO;
import com.floreantpos.model.util.DateUtil;

public class DailyDetailsReportData {

	public DailyDetailsReportData() {

	}

	public static class PettyCashReceive {
		private Date date;
		private String bankName;
		private String accountName;
		private String remarks;
		private double amount;

		public Date getDate() {
			return date;
		}

		public void setDate(Date date) {
			this.date = date;
		}

		public String getDateDisplay() {
			if (date != null) {
				return DateUtil.formatDateWithoutTime(DateUtil.convertServerTimeToBrowserTime(getDate()));
			}
			return StringUtils.EMPTY;
		}

		public String getBankName() {
			return bankName;
		}

		public void setBankName(String bankName) {
			this.bankName = bankName;
		}

		public String getAccountName() {
			return accountName;
		}

		public void setAccountName(String accountName) {
			this.accountName = accountName;
		}

		public String getRemarks() {
			return remarks;
		}

		public void setRemarks(String remarks) {
			this.remarks = remarks;
		}

		public double getAmount() {
			return amount;
		}

		public void setAmount(double amount) {
			this.amount = amount;
		}
	}

	public static class Expenditure {
		private Date date;
		private String item;
		private String paymentType;
		private long quantity;
		private double totalPrice;
		private String remarks;

		public Date getDate() {
			return date;
		}

		public void setDate(Date date) {
			this.date = date;
		}

		public String getDateDisplay() {
			if (date != null) {
				return DateUtil.formatDateWithTime(DateUtil.convertServerTimeToBrowserTime(getDate()));
			}
			return StringUtils.EMPTY;
		}

		public String getItem() {
			return item;
		}

		public void setItem(String item) {
			this.item = item;
		}

		public String getPaymentType() {
			return paymentType;
		}

		public void setPaymentType(String paymentType) {
			this.paymentType = paymentType;
		}

		public long getQuantity() {
			return quantity;
		}

		public void setQuantity(long quantity) {
			this.quantity = quantity;
		}

		public double getTotalPrice() {
			return totalPrice;
		}

		public void setTotalPrice(double totalPrice) {
			this.totalPrice = totalPrice;
		}

		public String getRemarks() {
			return remarks;
		}

		public void setRemarks(String remarks) {
			this.remarks = remarks;
		}

		public String getRecepientName() {
			if (StringUtils.isNotBlank(item)) {
				PayoutRecepient payoutRecepient = PayoutRecepientDAO.getInstance().get(item);
				return payoutRecepient.getName();
			}
			return StringUtils.EMPTY;
		}

	}

	public static class Income {
		private String item;
		private double doctorAmount;
		private double hospitalAmount;
		private double totalAmount;
		private String remarks;

		public String getItem() {
			return item;
		}

		public void setItem(String item) {
			this.item = item;
		}

		public double getDoctorAmount() {
			return doctorAmount;
		}

		public void setDoctorAmount(double doctorAmount) {
			this.doctorAmount = doctorAmount;
		}

		public double getHospitalAmount() {
			return hospitalAmount;
		}

		public void setHospitalAmount(double hospitalAmount) {
			this.hospitalAmount = hospitalAmount;
		}

		public double getTotalAmount() {
			return totalAmount;
		}

		public void setTotalAmount(double totalAmount) {
			this.totalAmount = totalAmount;
		}

		public String getRemarks() {
			return remarks;
		}

		public void setRemarks(String remarks) {
			this.remarks = remarks;
		}
	}
}
