package com.floreantpos.util;

import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.orocube.medlogics.Module;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

public class JWTUtil {
	public static final String QUERY_PARAM_TOKEN = "token"; //$NON-NLS-1$
	public static final String LOGIN_TOKEN = "jwt_login_token"; //$NON-NLS-1$
	public static final String STORE = "str"; //$NON-NLS-1$
	public static final String TERMINAL = "trm"; //$NON-NLS-1$
	public static final String USER = "usr"; //$NON-NLS-1$
	public static final String USER_OUTLET = "usr_oult"; //$NON-NLS-1$
	public static final String SIIOPA_CUSTOMER_EMAIL = "siiopa_customer_email"; //$NON-NLS-1$
	public static final String JWT_DEFAULT_SECRET_KEY = "thebestsecretkeyoro"; //$NON-NLS-1$
	public static final String LOG_ACCESS = "logAccess"; //$NON-NLS-1$

	public static String createToken(String secretKey, String siiopaCustomerEmail, String storeUUID) {
		return createToken(secretKey, siiopaCustomerEmail, null, null, null, storeUUID, null, true, 30);
	}

	public static String createToken(String secretKey, String siiopaCustomerEmail, String storeUUID, boolean logAccess) {
		return createToken(secretKey, siiopaCustomerEmail, null, null, null, storeUUID, null, logAccess, 30);
	}

	public static String createToken(String secretKey, User user, Terminal terminal, Store store, int tokenExpirationInSec) {
		return createToken(secretKey, null, user, null, terminal, store.getUuid(), null, true, tokenExpirationInSec);
	}

	public static String createToken(String secretKey, User user, Terminal terminal, Store store, Module department, int tokenExpirationInSec) {
		return createToken(secretKey, null, user, null, terminal, store.getUuid(), department, true, tokenExpirationInSec);
	}
	
	public static String createToken(String secretKey, String siiopaCustomerEmail, User user, Outlet outlet, Terminal terminal, String storeUUID,
			 boolean logAccess, int tokenExpirationInSec) {
		return createToken(secretKey, siiopaCustomerEmail, user, outlet, terminal, storeUUID, null, logAccess, tokenExpirationInSec);
	}

	public static String createToken(String secretKey, String siiopaCustomerEmail, User user, Outlet outlet, Terminal terminal, String storeUUID,
			Module department, boolean logAccess, int tokenExpirationInSec) {
		SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
		long nowMillis = System.currentTimeMillis();
		Date now = new Date(nowMillis);

		byte[] apiKeySecretBytes = new Base64().decode(secretKey);
		Key signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());

		java.util.Map<String, Object> dataMap = new HashMap<String, Object>();
		if (StringUtils.isNotBlank(siiopaCustomerEmail)) {
			dataMap.put(SIIOPA_CUSTOMER_EMAIL, siiopaCustomerEmail);
		}
		if (outlet != null) {
			dataMap.put(USER_OUTLET, outlet.getId());
		}
		if (user != null) {
			dataMap.put(USER, user.getId());
			dataMap.put(USER_OUTLET, user.getOutletId());
		}
		dataMap.put(TERMINAL, terminal == null ? null : terminal.getId());
		dataMap.put(STORE, storeUUID);
		dataMap.put(LOG_ACCESS, logAccess);
		if (department != null) {
			dataMap.put(Module.class.getName(), department.name());
		}

		//@formatter:off
		JwtBuilder builder = Jwts.builder()
				.setId(UUID.randomUUID().toString())
				.setIssuedAt(now)
				.setSubject("Oro") //$NON-NLS-1$
				.signWith(signatureAlgorithm, signingKey);
		builder = builder.setClaims(dataMap);
		
		//@formatter:on
		if (tokenExpirationInSec > 0) {
			long ttlMillis = tokenExpirationInSec * 1000;
			long expMillis = nowMillis + ttlMillis;
			Date exp = new Date(expMillis);
			builder = builder.setExpiration(exp);
		}
		return builder.compact();
	}

	public static java.util.Map<String, Object> getTokenValues(String token) {
		if (StringUtils.isBlank(token)) {
			return new HashMap<String, Object>();
		}
		String[] tokenValues = token.split("\\."); //$NON-NLS-1$
		if (tokenValues.length < 2) {
			return new HashMap<String, Object>();
		}
		return new JSONObject(new String(new Base64(true).decode(tokenValues[1]))).toMap();
	}

	public static java.util.Map<String, Object> decodeToken(String secretKey, String token) {
		java.util.Map<String, Object> tokenValuesMap = new HashMap<String, Object>();
		if (StringUtils.isBlank(token)) {
			return tokenValuesMap;
		}
		//@formatter:off
		Claims decodeToken = Jwts.parser()
				.setSigningKey(new Base64().decode(secretKey))
				.parseClaimsJws(token)
				.getBody();
		//@formatter:on
		for (String key : decodeToken.keySet()) {
			tokenValuesMap.put(key, decodeToken.get(key));
		}
		return tokenValuesMap;
	}
}
