package com.floreantpos.model;

public enum OTProcedureStatus {
	//@formatter:off
		SUCCESSFUL("Successful"), 
		ABORTED("Aborted"), 
		CONVERTED("Converted")
		;
		//@formatter:on
	private String displayString;

	private OTProcedureStatus(String displayString) {
		this.displayString = displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static OTProcedureStatus fromNameString(String name) {
		OTProcedureStatus[] statusList = values();
		for (OTProcedureStatus status : statusList) {
			if (status.name().equals(name)) {
				return status;
			}
		}
		return SUCCESSFUL;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

}
