package com.floreantpos.report.model;

import com.floreantpos.report.DueTicketReportData;
import com.floreantpos.swing.ListTableModel;

public class DueTicketReportModel extends ListTableModel {
	public DueTicketReportModel() {
		super(new String[] { "referralType", "referralBy", "receivable", "due", "received", "labDoctorFee", "RFonReport", "ofcNet", "RFonNetSales", "RFpayable",
				"RFpaid", "RFdue", "ofcTotal", "orderId", "orderDate", "patientName", "patientMobileNo", "referralId", "patientId", "totalRfAmount",
				"dueCollection", "taxAmount" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		DueTicketReportData reportData = (DueTicketReportData) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return reportData.getReferralType();

			case 1:
				return reportData.getReferralBy();

			case 2:
				return reportData.getReceivable();

			case 3:
				return reportData.getDue();

			case 4:
				return reportData.getReceived();

			case 5:
				return reportData.getLabDoctorFee();

			case 6:
				return reportData.getRfOnReport();

			case 7:
				return reportData.getOfficeNet();

			case 8:
				return reportData.getRfOnNetSales();

			case 9:
				return reportData.getRfPayableAmount();

			case 10:
				return reportData.getRfPaid();

			case 11:
				return reportData.getRfFeeDue();

			case 12:
				return reportData.getOfficeTotal();

			case 13:
				return reportData.getOrderId();

			case 14:
				return reportData.getOrderDate();

			case 15:
				return reportData.getPatientName();

			case 16:
				return reportData.getPatientMobileNo();

			case 17:
				return reportData.getReferralId();

			case 18:
				return reportData.getPatientId();

			case 19:
				return reportData.getTotalRF();

			case 20:
				return reportData.getDueColl();
				
			case 21:
				return reportData.getTaxAmount();

		}
		return null;
	}

}