package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseCronJob;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "executionTimeValid" })
@XmlRootElement
public class CronJob extends BaseCronJob implements org.quartz.InterruptableJob, TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public CronJob() {
	}

	/**
	 * Constructor for primary key
	 */
	public CronJob(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public void execute(JobExecutionContext context) throws JobExecutionException {
	}

	@Override
	public void interrupt() throws UnableToInterruptJobException {
	}

	@XmlTransient
	public boolean isExecutionTimeValid() {
		return this.isExecutionTimeValid(this.getExecutionTime());
	}

	public boolean isExecutionTimeValid(String executionTime) {
		if (StringUtils.isBlank(executionTime)) {
			return Boolean.FALSE;
		}
		return executionTime.split(":").length == 2; //$NON-NLS-1$
	}

	public Integer getAutoSyncInterval() {
		String executionTime = getExecutionTime();
		if (StringUtils.isBlank(executionTime)) {
			return null;
		}

		if (isExecutionTimeValid(executionTime)) {
			int autoSyncIntervel = Integer.parseInt(executionTime.split(":")[1]);
			if (autoSyncIntervel == 0) {
				return 60;
			}
			return autoSyncIntervel;
		}
		return null;
	}

}