package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.OutdoorDoctorProfile;
import com.floreantpos.model.Outlet;

public class OutdoorDoctorProfileDAO extends BaseOutdoorDoctorProfileDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session s) throws HibernateException {
		OutdoorDoctorProfile doctorProfile = (OutdoorDoctorProfile) obj;
		doctorProfile.setDeleted(true);
		update(doctorProfile, s);
	}

	@Override
	public List<OutdoorDoctorProfile> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OutdoorDoctorProfile.class); //$NON-NLS-1$
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(OutdoorDoctorProfile.PROP_ACTIVE, Boolean.TRUE));

			criteria.addOrder(Order.asc(OutdoorDoctorProfile.PROP_DOCTOR_NAME).ignoreCase());
			return criteria.list();
		}
	}

	public List<OutdoorDoctorProfile> findAll(Outlet outlet) {
		return findAllActive(outlet, false);
	}

	public List<OutdoorDoctorProfile> findAllActive(Outlet outlet, boolean showOnlyActive) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OutdoorDoctorProfile.class); //$NON-NLS-1$
			addDeletedFilter(criteria);

			if (showOnlyActive) {
				criteria.add(Restrictions.eq(OutdoorDoctorProfile.PROP_ACTIVE, Boolean.TRUE));
			}

			if (outlet != null) {
				criteria.add(Restrictions.eq(OutdoorDoctorProfile.PROP_OUTLET_ID, outlet.getId()));
			}

			criteria.addOrder(Order.asc(OutdoorDoctorProfile.PROP_DOCTOR_NAME).ignoreCase());
			return criteria.list();
		}
	}

	public OutdoorDoctorProfile getProfile(String doctorId, String outletId) {

		if (StringUtils.isBlank(doctorId)) {
			return null;
		}

		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OutdoorDoctorProfile.class); //$NON-NLS-1$
			addDeletedFilter(criteria);
			
			criteria.add(Restrictions.eq(OutdoorDoctorProfile.PROP_ACTIVE, Boolean.TRUE));
			criteria.add(Restrictions.eq(OutdoorDoctorProfile.PROP_DOCTOR_ID, doctorId));

			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(OutdoorDoctorProfile.PROP_OUTLET_ID, outletId));
			}
			criteria.setMaxResults(1);

			return (OutdoorDoctorProfile) criteria.uniqueResult();
		}

	}

}