package com.orocube.cloudflare.r2;

import java.util.Date;

/**
 * Metadata about files stored in Cloudflare R2.
 * POJO (no Hibernate mapping) - used to represent R2 object information.
 */
public class R2StorageMetadata {

	private String id;
	private String r2Key;
	private String fileName;
	private String contentType;
	private Long fileSize;
	private Date uploadedDate;
	private String category;
	private String description;
	private String url;

	public R2StorageMetadata() {
	}

	public R2StorageMetadata(String r2Key, String fileName, String contentType, Long fileSize) {
		this.r2Key = r2Key;
		this.fileName = fileName;
		this.contentType = contentType;
		this.fileSize = fileSize;
		this.uploadedDate = new Date();
	}

	/**
	 * Get unique identifier.
	 *
	 * @return id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Set unique identifier.
	 *
	 * @param id unique identifier
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Get R2 object key (path in bucket).
	 *
	 * @return R2 key (e.g., "PRODUCTS/uuid.jpg")
	 */
	public String getR2Key() {
		return r2Key;
	}

	/**
	 * Set R2 object key.
	 *
	 * @param r2Key R2 object key
	 */
	public void setR2Key(String r2Key) {
		this.r2Key = r2Key;
	}

	/**
	 * Get original file name.
	 *
	 * @return file name
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * Set original file name.
	 *
	 * @param fileName file name
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * Get content type (MIME type).
	 *
	 * @return content type (e.g., "image/jpeg")
	 */
	public String getContentType() {
		return contentType;
	}

	/**
	 * Set content type.
	 *
	 * @param contentType MIME type
	 */
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	/**
	 * Get file size in bytes.
	 *
	 * @return file size
	 */
	public Long getFileSize() {
		return fileSize;
	}

	/**
	 * Set file size in bytes.
	 *
	 * @param fileSize file size
	 */
	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}

	/**
	 * Get upload date.
	 *
	 * @return uploaded date
	 */
	public Date getUploadedDate() {
		return uploadedDate;
	}

	/**
	 * Set upload date.
	 *
	 * @param uploadedDate upload date
	 */
	public void setUploadedDate(Date uploadedDate) {
		this.uploadedDate = uploadedDate;
	}

	/**
	 * Get category (e.g., "PRODUCTS", "SIGNATURE", "PATIENT_IMAGE").
	 *
	 * @return category
	 */
	public String getCategory() {
		return category;
	}

	/**
	 * Set category.
	 *
	 * @param category category
	 */
	public void setCategory(String category) {
		this.category = category;
	}

	/**
	 * Get description.
	 *
	 * @return description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Set description.
	 *
	 * @param description description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Get public URL (if applicable).
	 *
	 * @return URL
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * Set public URL.
	 *
	 * @param url URL
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	@Override
	public String toString() {
		return "R2StorageMetadata{" +
				"id='" + id + '\'' +
				", r2Key='" + r2Key + '\'' +
				", fileName='" + fileName + '\'' +
				", contentType='" + contentType + '\'' +
				", fileSize=" + fileSize +
				", category='" + category + '\'' +
				'}';
	}
}
