/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;

import com.floreantpos.PosLog;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.DoctorTimeSchedule;
import com.floreantpos.model.dao.DoctorDAO;

public class UpdateDBTo429 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo429(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {
		updateDoctors();
	}

	public void updateDoctors() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema."); //$NON-NLS-1$ //$NON-NLS-2$

		try (Session session = sessionFactory.openSession()) {
			Criteria criteria = session.createCriteria(Doctor.class);
			criteria.setProjection(Projections.rowCount());

			int totalRecords = ((Long) criteria.uniqueResult()).intValue();

			PosLog.info(UpdateDBTo429.class, "Found total doctors: " + totalRecords); //$NON-NLS-1$

			criteria = session.createCriteria(Doctor.class);
			criteria.setMaxResults(totalRecords);

			List<Doctor> doctors = criteria.list();

			Transaction transaction = session.beginTransaction();
			for (Doctor doctor : doctors) {
				List<DoctorTimeSchedule> schedules = doctor.getSchedules();
				doctor.setHasSchedule(schedules != null && schedules.size() > 0);
				DoctorDAO.getInstance().saveOrUpdate(doctor, session);
			}
			transaction.commit();
		}

		PosLog.info(getClass(), schemaName + " update completed successfully"); //$NON-NLS-1$
	}
}