package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseAgent;
import com.floreantpos.model.util.ReferralCommissionType;
import com.floreantpos.util.POSUtil;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "propertiesContainer" })
public class Agent extends BaseAgent {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Agent () {
    }

	/**
	 * Constructor for primary key
	 */
	public Agent (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void putRfRateOnReport(MenuCategory category, String inputedRFValueString) {
		String inputedRFType = inputedRFValueString.endsWith("%") ? ReferralCommissionType.PERCENTAGE.name() : ReferralCommissionType.FIXEDAMOUNT.name(); //$NON-NLS-1$
		double inputedRfRateValue = POSUtil.parseDouble(inputedRFValueString.replaceAll("%", "")); //$NON-NLS-1$ //$NON-NLS-2$

		String commissionTypeKey = "rf_" + category.getId() + "_type"; //$NON-NLS-1$ //$NON-NLS-2$
		String commissionRateKey = "rf_" + category.getId() + "_rate"; //$NON-NLS-1$ //$NON-NLS-2$

		double categoryRfRate = category.getRfRateOnReport();
		String categoryType = category.getRfOnReportType();
		if (categoryType != null && categoryType.equals(inputedRFType) && inputedRfRateValue == categoryRfRate) {
			removeProperty(commissionTypeKey);
			removeProperty(commissionRateKey);
			return;
		}
		addProperty(commissionTypeKey, inputedRFType);
		addProperty(commissionRateKey, String.valueOf(inputedRfRateValue));
	}

	public void putRfGroupRateOnReport(MenuGroup group, String inputedRFValueString) {
		String inputedRFType = inputedRFValueString.endsWith("%") ? ReferralCommissionType.PERCENTAGE.name() : ReferralCommissionType.FIXEDAMOUNT.name(); //$NON-NLS-1$
		double inputedRfRateValue = POSUtil.parseDouble(inputedRFValueString.replaceAll("%", "")); //$NON-NLS-1$ //$NON-NLS-2$

		String commissionTypeKey = "rf_group_" + group.getId() + "_type"; //$NON-NLS-1$ //$NON-NLS-2$
		String commissionRateKey = "rf_group_" + group.getId() + "_rate"; //$NON-NLS-1$ //$NON-NLS-2$

		double categoryRfRate = group.getRfRateOnReport();
		String categoryType = group.getRfOnReportType();
		if (categoryType != null && categoryType.equals(inputedRFType) && inputedRfRateValue == categoryRfRate) {
			removeProperty(commissionTypeKey);
			removeProperty(commissionRateKey);
			return;
		}
		addProperty(commissionTypeKey, inputedRFType);
		addProperty(commissionRateKey, String.valueOf(inputedRfRateValue));
	}

	public String getRfTypeOnReport(MenuCategory menuCategory) {
		String rfTypeString = getProperty("rf_" + menuCategory.getId() + "_type"); //$NON-NLS-1$ //$NON-NLS-2$
		if (StringUtils.isNotBlank(rfTypeString)) {
			return rfTypeString;
		}
		return menuCategory.getRfOnReportType();
	}

	public double getRfRateOnReport(MenuCategory menuCategory) {
		String rfRateString = getProperty("rf_" + menuCategory.getId() + "_rate"); //$NON-NLS-1$ //$NON-NLS-2$
		if (StringUtils.isNotBlank(rfRateString)) {
			return POSUtil.parseDouble(rfRateString);
		}
		return menuCategory.getRfRateOnReport();
	}

	public String getRfGroupTypeOnReport(MenuGroup group) {
		String rfTypeString = getProperty("rf_group_" + group.getId() + "_type"); //$NON-NLS-1$ //$NON-NLS-2$
		if (StringUtils.isNotBlank(rfTypeString)) {
			return rfTypeString;
		}
		return group.getRfOnReportType();
	}

	public double getRfGroupRateOnReport(MenuGroup group) {
		String rfRateString = getProperty("rf_group_" + group.getId() + "_rate"); //$NON-NLS-1$ //$NON-NLS-2$
		if (StringUtils.isNotBlank(rfRateString)) {
			return POSUtil.parseDouble(rfRateString);
		}
		return group.getRfRateOnReport();
	}
}