/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Challan;
import com.floreantpos.model.ChallanItemDto;
import com.floreantpos.swing.ListTableModel;

public class ChallanReportModel extends ListTableModel<ChallanItemDto> {
	private boolean jasperModel = true;

	public ChallanReportModel(Challan challan) {
		super(new String[] { "itemName", "qty", "unit", "itemSubtotalAmount", "testCategoryName", "productType", "labTestRoomNo", "itemDiscount", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
				"ItemDiscountName", "sampleId" }); //$NON-NLS-1$ //$NON-NLS-2$

		setRows(challan.getItems());
	}

	public void setJasperModel(boolean jasperModel) {
		this.jasperModel = jasperModel;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		ChallanItemDto labTestItem = (ChallanItemDto) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				String startTag = jasperModel ? "<span style='font-family: SolaimanLipi;'>" : ""; //$NON-NLS-1$
				String endTag = jasperModel ? "</span>" : ""; //$NON-NLS-1$
				return startTag + labTestItem.getTicketItemName() + endTag;

			case 1:
				return labTestItem.getItemQuantity();

			case 2:
				return labTestItem.getTicketItemUnit();

			case 3:
			case 7:
				return 0D;

			case 4:
			case 5:
			case 6:
			case 8:
			case 9:
				return StringUtils.EMPTY;
			case 14:
				labTestItem.getBarcode();

		}
		return null;
	}

}
