/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;

/**
 * Database update to fix NULL CTYPE (discriminator) values in CUSTOMER table.
 * The discriminator-value was changed from "null" to "customer" in Customer.hbm.xml,
 * so all existing records with NULL CTYPE need to be updated to 'customer'.
 */
public class UpdateDBTo479 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo479(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema - fixing NULL CTYPE values in CUSTOMER table"); //$NON-NLS-1$ //$NON-NLS-2$

		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();

			// Update NULL CTYPE values to 'customer' (the default discriminator value)
			String updateQuery = "UPDATE " + schemaName + ".CUSTOMER SET CTYPE = 'customer' WHERE CTYPE IS NULL";
			int updatedRows = session.createSQLQuery(updateQuery).executeUpdate();

			PosLog.info(getClass(), "Updated " + updatedRows + " customer records with NULL CTYPE to 'customer'");

			transaction.commit();
		} catch (Exception e) {
			PosLog.error(getClass(), "Error updating CUSTOMER table CTYPE values", e);
			throw new RuntimeException("Failed to update CUSTOMER table CTYPE values", e);
		}

		PosLog.info(getClass(), schemaName + " update completed successfully"); //$NON-NLS-1$
	}

}
