package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the ATTENDENCE_HISTORY table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="ATTENDENCE_HISTORY"
 */

public abstract class BaseAttendenceHistory  implements Comparable, Serializable {

	public static String REF = "AttendenceHistory"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CLOCK_IN_HOUR = "clockInHour"; //$NON-NLS-1$
	public static String PROP_CLOCK_OUT_TIME = "clockOutTime"; //$NON-NLS-1$
	public static String PROP_SHIFT_ID = "shiftId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CLOCKED_OUT = "clockedOut"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_CLOCK_IN_TIME = "clockInTime"; //$NON-NLS-1$
	public static String PROP_TERMINAL_ID = "terminalId"; //$NON-NLS-1$
	public static String PROP_CLOCK_OUT_HOUR = "clockOutHour"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseAttendenceHistory () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseAttendenceHistory (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date clockInTime;
				private java.util.Date clockOutTime;
				private java.lang.Short clockInHour;
				private java.lang.Short clockOutHour;
				private java.lang.Boolean clockedOut;
				private java.lang.String outletId;
				private java.lang.String userId;
				private java.lang.String shiftId;
				private java.lang.Integer terminalId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CLOCK_IN_TIME
	 */

	public java.util.Date getClockInTime () {
			return clockInTime;
	}



	/**
	 * Set the value related to the column: CLOCK_IN_TIME
	 * @param clockInTime the CLOCK_IN_TIME value
	 */
			public void setClockInTime (java.util.Date clockInTime) {
			this.clockInTime = clockInTime;
	}



	/**
	 * Return the value associated with the column: CLOCK_OUT_TIME
	 */

	public java.util.Date getClockOutTime () {
			return clockOutTime;
	}



	/**
	 * Set the value related to the column: CLOCK_OUT_TIME
	 * @param clockOutTime the CLOCK_OUT_TIME value
	 */
			public void setClockOutTime (java.util.Date clockOutTime) {
			this.clockOutTime = clockOutTime;
	}



	/**
	 * Return the value associated with the column: CLOCK_IN_HOUR
	 */

	public java.lang.Short getClockInHour () {
			return clockInHour;
	}



	/**
	 * Set the value related to the column: CLOCK_IN_HOUR
	 * @param clockInHour the CLOCK_IN_HOUR value
	 */
			public void setClockInHour (java.lang.Short clockInHour) {
			this.clockInHour = clockInHour;
	}



	/**
	 * Return the value associated with the column: CLOCK_OUT_HOUR
	 */

	public java.lang.Short getClockOutHour () {
			return clockOutHour;
	}



	/**
	 * Set the value related to the column: CLOCK_OUT_HOUR
	 * @param clockOutHour the CLOCK_OUT_HOUR value
	 */
			public void setClockOutHour (java.lang.Short clockOutHour) {
			this.clockOutHour = clockOutHour;
	}



	/**
	 * Return the value associated with the column: CLOCKED_OUT
	 */

	public java.lang.Boolean isClockedOut () {
					return clockedOut == null ? Boolean.FALSE : clockedOut;
		}

	public java.lang.Boolean getClockedOut () {
				return clockedOut == null ? Boolean.FALSE : clockedOut;
			}


	/**
	 * Set the value related to the column: CLOCKED_OUT
	 * @param clockedOut the CLOCKED_OUT value
	 */
			public void setClockedOut (java.lang.Boolean clockedOut) {
			this.clockedOut = clockedOut;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: SHIFT_ID
	 */

	public java.lang.String getShiftId () {
			return shiftId;
	}



	/**
	 * Set the value related to the column: SHIFT_ID
	 * @param shiftId the SHIFT_ID value
	 */
			public void setShiftId (java.lang.String shiftId) {
			this.shiftId = shiftId;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public java.lang.Integer getTerminalId () {
						return terminalId == null ? Integer.valueOf(0) : terminalId;
		}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminalId the TERMINAL_ID value
	 */
			public void setTerminalId (java.lang.Integer terminalId) {
			this.terminalId = terminalId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.AttendenceHistory)) return false;
		else {
			com.floreantpos.model.AttendenceHistory attendenceHistory = (com.floreantpos.model.AttendenceHistory) obj;
			if (null == this.getId() || null == attendenceHistory.getId()) return this == obj;
			else return (this.getId().equals(attendenceHistory.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}