package com.floreantpos.model.util;

import com.floreantpos.model.DoctorTimeSchedule;
import com.floreantpos.model.OutdoorDoctorProfile;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Patient;

public class OutdoorTicketBookingUtil {

	public static double calculateOutdoorFee(Double basePrice, Outlet outlet, OutdoorDoctorProfile doctorProfile, Patient patient,
			String currentOutdoorTicketId, boolean applyRevisitFee) {
		return calculateOutdoorFee(basePrice, outlet, doctorProfile, null, patient, currentOutdoorTicketId, applyRevisitFee);
	}

	public static double calculateOutdoorFee(Double basePrice, Outlet outlet, OutdoorDoctorProfile doctorProfile, String shiftId, Patient patient,
			String currentOutdoorTicketId, boolean applyRevisitFee) {
		if (!outlet.isOutdoorFeeTypeConfigured()) {
			return basePrice;
		}

		Double outdoorCharge = basePrice;
		OutdoorConfigurationFeeType feeType = outlet.getOutdoorFeeType();
		boolean isFixedFee = OutdoorConfigurationFeeType.FixedOutdoorFee == feeType;
		if (isFixedFee) {
			if (applyRevisitFee) {
				outdoorCharge = outlet.getRevisitFee();
			}
			else {
				outdoorCharge = outlet.getOutdoorFee();
			}
			return outdoorCharge;
		}

		if (doctorProfile != null) {
			DoctorTimeSchedule currentTimeSchedule = OutdoorDoctorScheduleUtil.getCurrentDoctorSchedule(doctorProfile, shiftId);
			if (currentTimeSchedule != null) {
				if (applyRevisitFee) {
					outdoorCharge = currentTimeSchedule.getRevisitFee();
				}
				else {
					outdoorCharge = currentTimeSchedule.getOutdoorFee();
				}
				return outdoorCharge;
			}
			if (applyRevisitFee) {
				outdoorCharge = doctorProfile.getRevisitFee();
			}
			else {
				outdoorCharge = doctorProfile.getOutdoorFee();
			}
		}

		return outdoorCharge;
	}

}
