package com.floreantpos.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.Store;

public class ReceiptUtil {
	private static Map<String, String> defaultValueMap = new HashMap<>();

	static {
		// DEFAULT TICKET
		defaultValueMap.put(AppConstants.PROP_TICKET_HEADER,
				"<storeName>$storeName</storeName><br><storeAddress1>$storeAddress1</storeAddress1><br><storePhoneNo>$storePhoneNo</storePhoneNo><br>"); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_ORDER_INFO,
				"<receiptType><b>$receiptType</b></receiptType><br><ticketId>CHK# : $ticketId</ticketId><br><splitTicketId>#Split#  $splitTicketId</splitTicketId><br><tokenNo><b>TOKEN # $tokenNo</b></tokenNo><br>"); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_ADDITIONAL_ORDER_INFO_1,
				"<orderType>* $orderType *</orderType><br><terminalId>Terminal#: $terminalId</terminalId><br><tableNo>Table#: $tableNo  Guest: $guestCount</tableNo> <br><serverName>Server: $serverName</serverName><br><printDate>Printed: $printDate</printDate>"); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_ADDITIONAL_ORDER_INFO_2,
				"printDate><br><br><customerName>*Delivery to *<br>$customerName</customerName><br><deliveryAddress>$deliveryAddress</deliveryAddress><br><deliveryDate>$deliveryDate</deliveryDate>"); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_TICKET_FOOTER, ""); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_TICKET_BOTTOM, ""); //$NON-NLS-1$

		// KITCHEN TICKET

		defaultValueMap.put(AppConstants.PROP_KITCHEN_TICKET_HEADER, "<orderType>* $orderType *</orderType><br>"); //$NON-NLS-1$

		defaultValueMap.put(AppConstants.PROP_KITCHEN_ORDER_INFO, ""); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_KITCHEN_ADDITIONAL_ORDER_INFO_1,
				"<br><ticketId>CHK# $ticketId</ticketId><br><tableNo> Table: $tableNo</tableNo><br><customerName>Customer: $customerName</customerName><br><serverName>Server: $serverName</serverName><br><printDate>Printed: $printDate</printDate>"); //$NON-NLS-1$

		defaultValueMap.put(AppConstants.PROP_KITCHEN_ADDITIONAL_ORDER_INFO_2, ""); //$NON-NLS-1$

		defaultValueMap.put(AppConstants.PROP_KITCHEN_TICKET_FOOTER, ""); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_KITCHEN_TICKET_BOTTOM, ""); //$NON-NLS-1$

		// LOGO
		defaultValueMap.put(AppConstants.PROP_SHOW_KITCHEN_HEADER_LOGO, "false"); //$NON-NLS-1$
		defaultValueMap.put(AppConstants.PROP_SHOW_HEADER_LOGO, "false"); //$NON-NLS-1$
	}

	public static String getReceiptSection(Store store, String propertyName, String orderTypeId) {
		String orderTypeProperty = orderTypeId + "." + propertyName; //$NON-NLS-1$
		String property = POSUtil.readLongProperty(store.getProperties(), orderTypeProperty);
		if (property == null) {
			property = POSUtil.readLongProperty(store.getProperties(), propertyName);
			if (StringUtils.isBlank(property)) {
				property = defaultValueMap.get(propertyName);
			}
		}

		return property;
	}

	public static boolean getReceiptBooleanProp(Store store, String propertyName, String orderTypeId) {
		String property = orderTypeId + "." + propertyName;//$NON-NLS-1$
		if (store.hasProperty(property)) {
			return POSUtil.getBoolean(store.getProperty(property));
		}
		else {
			return POSUtil.getBoolean(store.getProperty(propertyName));
		}
	}

	public static void populateDefaultTicketReceiptProperties(Store store) {
		POSUtil.storeLongProperty(store.getProperties(), AppConstants.PROP_TICKET_HEADER, defaultValueMap.get(AppConstants.PROP_TICKET_HEADER), 255);
		POSUtil.storeLongProperty(store.getProperties(), AppConstants.PROP_ORDER_INFO, defaultValueMap.get(AppConstants.PROP_ORDER_INFO), 255);
		POSUtil.storeLongProperty(store.getProperties(), AppConstants.PROP_ADDITIONAL_ORDER_INFO_1,
				defaultValueMap.get(AppConstants.PROP_ADDITIONAL_ORDER_INFO_1), 255);
		POSUtil.storeLongProperty(store.getProperties(), AppConstants.PROP_ADDITIONAL_ORDER_INFO_2,
				defaultValueMap.get(AppConstants.PROP_ADDITIONAL_ORDER_INFO_2), 255);

	}

	public static void populateDefaultKitchenReceiptProperties(Store store) {
		POSUtil.storeLongProperty(store.getProperties(), AppConstants.PROP_KITCHEN_TICKET_HEADER, defaultValueMap.get(AppConstants.PROP_KITCHEN_TICKET_HEADER),
				255);
		POSUtil.storeLongProperty(store.getProperties(), AppConstants.PROP_KITCHEN_ADDITIONAL_ORDER_INFO_1,
				defaultValueMap.get(AppConstants.PROP_KITCHEN_ADDITIONAL_ORDER_INFO_1), 255);
	}
}
