package com.floreantpos.payment;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.util.NumberUtil;

public abstract class AbstractPaymentPlugin implements PaymentPlugin {

	@Override
	public String getId() {
		return null;
	}

	protected double getRefundableAmount(Ticket ticket) {
		double refundableAmount = 0;
		if (ticket.getDueAmount() >= 0) {
			return 0;
		}
		refundableAmount = Math.abs(ticket.getDueAmount());
		return NumberUtil.roundToTwoDigit(refundableAmount);
	}

	protected double calculateTaxAmount(Ticket ticket) {
		double totalTransactionTaxAmount = 0;
		for (PosTransaction t : ticket.getTransactions()) {
			if (!(t instanceof RefundTransaction || t.isVoided())) {
				totalTransactionTaxAmount += t.getTaxAmount();
			}
		}
		return totalTransactionTaxAmount;
	}
}
