package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.BankAccount;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.LdfPayTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.FeePaymentMapper;

public class LdfPayTransactionDAO extends BaseLdfPayTransactionDAO {

	public LdfPayTransactionDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public LdfPayTransaction createLdfPayTransaction(FeePaymentMapper ldfPaymentMapper, Session session) throws Exception {
		return createLdfPayTransaction(ldfPaymentMapper, null, session);
	}

	public LdfPayTransaction createLdfPayTransaction(FeePaymentMapper ldfPaymentMapper, String batchNo, Session session) throws Exception {
		Customer referrer = ldfPaymentMapper.getReferrer();
		if (referrer == null) {
			return null;
		}

		CashDrawer cashDrawer = ldfPaymentMapper.getCashDrawer();
		CustomPayment customPayment = ldfPaymentMapper.getCustomPayment();
		double tenderAmount = ldfPaymentMapper.getTenderAmount();
		double payoutAmount = ldfPaymentMapper.getPayoutAmount();
		BankAccount bankAccount = ldfPaymentMapper.getBankAccount();

//		StoreSession storeSession = DataProvider.get().getStoreSession();
//		if (storeSession == null && cashDrawer != null) {
//			storeSession = cashDrawer.getStoreSession();
//		}

		LdfPayTransaction ldfPayTransaction = new LdfPayTransaction();

		if (customPayment != null) {
			ldfPayTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
			ldfPayTransaction.setCaptured(true);
			ldfPayTransaction.setConfirmPayment(true);
			ldfPayTransaction.setCustomPaymentId(customPayment.getId());
			ldfPayTransaction.setCustomPaymentRef(ldfPaymentMapper.getCustomPaymnetRef());
			ldfPayTransaction.setCustomPaymentName(customPayment.getName());

			if (bankAccount != null) {
				ldfPayTransaction.setLinkedBankAccount(bankAccount);
			}
		}
		else {
			ldfPayTransaction.setPaymentType(PaymentType.CASH);
		}

		if (ldfPaymentMapper.isRefundPayment()) {
			ldfPayTransaction.setTransactionType(TransactionType.IN.name());
		}
		else {
			ldfPayTransaction.setTransactionType(TransactionType.OUT.name());
		}

		ldfPayTransaction.setAmount(payoutAmount);

		ldfPayTransaction.setTenderAmount(tenderAmount);
		if (tenderAmount > payoutAmount) {
			ldfPayTransaction.setChangeAmount(tenderAmount - payoutAmount);
		}
		ldfPayTransaction.setRecepientCustomer(referrer);
		ldfPayTransaction.setCashDrawer(cashDrawer);
//		if (storeSession != null) {
//			ldfPayTransaction.setStoreSessionId(storeSession.getId());
//		}

		ldfPayTransaction.setTransTicketIds(ldfPaymentMapper.getTicketIds());
		ldfPayTransaction.setOutletId(DataProvider.get().getOutletId());
		ldfPayTransaction.setUser(ldfPaymentMapper.getUser());
		ldfPayTransaction.setServer(ldfPaymentMapper.getUser());
		ldfPayTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
		ldfPayTransaction.setTerminal(ldfPaymentMapper.getTerminal());
		ldfPayTransaction.setTicketType(ldfPaymentMapper.getTicketTypeNo());

		if (StringUtils.isNotBlank(batchNo)) {
			ldfPayTransaction.setBatchNo(batchNo);
		}

		saveOrUpdate(ldfPayTransaction, session);
		return ldfPayTransaction;
	}

	//	public List<LdfPayTransaction> findLDFPayments(Date startTime, Date endTime, Customer referrer) {
	//		return findLDFPayments(startTime, endTime, referrer, "", null);
	//	}

	public List<LdfPayTransaction> findLDFPayments(Date startTime, Date endTime, Customer referrer, String orderNo, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(LdfPayTransaction.class);
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(LdfPayTransaction.PROP_OUTLET_ID, outletId));
			}
			criteria.add(Restrictions.eq(LdfPayTransaction.PROP_VOIDED, false));

			if (StringUtils.isNotBlank(orderNo)) {
				criteria.add(Restrictions.ilike(LdfPayTransaction.PROP_TRANS_TICKET_IDS, orderNo, MatchMode.ANYWHERE));
			}
			else {
				criteria.add(Restrictions.between(LdfPayTransaction.PROP_TRANSACTION_TIME, startTime, endTime));
				if (referrer != null) {
					criteria.add(Restrictions.eq(LdfPayTransaction.PROP_RECEPIENT_ID, referrer.getId()));
				}

				TicketType ticketType = DataProvider.get().getTicketType();
				if (ticketType != null) {
					criteria.add(Restrictions.eq(LdfPayTransaction.PROP_TICKET_TYPE, ticketType.getTypeNo()));
				}
			}
			criteria.addOrder(Order.desc(LdfPayTransaction.PROP_TRANSACTION_TIME));
			return criteria.list();
		}
	}

}