package com.orocube.medlogics.chemo;

/**
 * Status enum for Chemotherapy treatment
 */
public enum ChemotherapyStatus {
	PLANNED("Planned", 0), ONGOING("Ongoing", 1), COMPLETED("Completed", 2), DISCONTINUED("Discontinued", 3), ON_HOLD("On Hold", 4);

	private final String displayString;
	private final int index;

	ChemotherapyStatus(String displayString, int index) {
		this.displayString = displayString;
		this.index = index;
	}

	public String getDisplayString() {
		return displayString;
	}

	public int getIndex() {
		return index;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public static ChemotherapyStatus fromString(String status) {
		if (status == null) {
			return null;
		}
		for (ChemotherapyStatus s : ChemotherapyStatus.values()) {
			if (s.name().equalsIgnoreCase(status) || s.displayString.equalsIgnoreCase(status)) {
				return s;
			}
		}
		return null;
	}
}
