package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.base.BaseMenuShift;
import com.floreantpos.util.ShiftUtil;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "dayOfWeekAsString", "formattedStartTime", "formattedEndTime" })
public class MenuShift extends BaseMenuShift {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public MenuShift() {
	}

	/**
	 * Constructor for primary key
	 */
	public MenuShift(java.lang.String id, java.lang.String outletId) {
		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public MenuShift(java.lang.String id, java.lang.String outletId, java.lang.String name) {

		super(id, outletId, name);
	}

	/*[CONSTRUCTOR MARKER END]*/
	private String dayOfWeekAsString;

	public String getDayOfWeekAsString() {
		String daysDisplay = ""; //$NON-NLS-1$
		String daysString = getDaysOfWeek();
		if (StringUtils.isNotEmpty(daysString)) {
			String[] split = daysString.split(","); //$NON-NLS-1$
			if (split.length == 7)
				return Messages.getString("MenuShift.2"); //$NON-NLS-1$
			if (split.length > 0) {
				for (int i = 0; i < split.length; i++) {
					int day = Integer.valueOf(split[i]);
					DayOfWeek week = DayOfWeek.getDayOfWeek(day);
					daysDisplay += week.name();
					if (i != split.length - 1) {
						daysDisplay += ","; //$NON-NLS-1$
					}
				}
			}
		}
		return daysDisplay;
	}

	public void setDayOfWeekAsString(String dayOfWeekAsString) {
		this.dayOfWeekAsString = dayOfWeekAsString;
	}

	public boolean isAnyDay() {
		String daysString = getDaysOfWeek();
		if (daysString != null) {
			String[] split = daysString.split(","); //$NON-NLS-1$
			if (split.length == 7) {
				return true;
			}
		}
		return false;
	}

	public void setAnyDay(boolean selected) {
		if (selected) {
			setDaysOfWeek(Messages.getString("MenuShift.5")); //$NON-NLS-1$
		}
	}

	@XmlTransient
	public String getFormattedStartTime() {
		return ShiftUtil.buildShiftTimeRepresentation(getStartTime()); //$NON-NLS-1$
	}

	public void setFormattedStartTime(String formattedStartTime) {

	}

	@XmlTransient
	public String getFormattedEndTime() {
		return ShiftUtil.buildShiftTimeRepresentation(getEndTime());
	}

	public void setFormattedEndTime(String formattedEndTime) {

	}

	@Override
	public String toString() {
		return getName();
	}

}