package com.floreantpos.model;

import com.floreantpos.POSConstants;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.google.gson.JsonObject;

public class DeliveryFee {
	private String id;
	private Double subtotalAmount;
	private LogicalExpression logicalExpression;
	private Double feeAmount;

	public DeliveryFee() {
		id = NumericGlobalIdGenerator.generateGlobalId();
	}

	public Double getSubtotalAmount() {
		return subtotalAmount == null ? 0D : subtotalAmount;
	}

	public void setSubtotalAmount(Double amount) {
		this.subtotalAmount = amount;
	}

	public LogicalExpression getLogicalExpression() {
		return logicalExpression;
	}

	public void setLogicalExpression(LogicalExpression expression) {
		this.logicalExpression = expression;
	}

	public Double getFeeAmount() {
		return feeAmount == null ? 0D : feeAmount;
	}

	public void setFeeAmount(Double feeAmount) {
		this.feeAmount = feeAmount;
	}

	public String getSubtotalAmountWithExpression() {
		return POSConstants.SUBTOTAL + " " + getLogicalExpression().getExpression() + " " //$NON-NLS-1$//$NON-NLS-2$
				+ NumberUtil.format(getSubtotalAmount());
	}

	public void setSubtotalAmountWithExpression(String value) {
	}

	public JsonObject toJson() {
		JsonObject jsonObject = new JsonObject();
		jsonObject.addProperty("subtotalAmount", NumberUtil.format(this.getSubtotalAmount())); //$NON-NLS-1$
		jsonObject.addProperty("expression", this.getLogicalExpression().name()); //$NON-NLS-1$
		jsonObject.addProperty("feeAmount", NumberUtil.format(this.getFeeAmount())); //$NON-NLS-1$
		return jsonObject;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
}
