package com.floreantpos.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;

import com.floreantpos.model.RentalLease;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.RentalLeaseDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;

public class LeaseIdGenerator extends GlobalIdGenerator {

	private static final String QUOTATION_SEQUENCE_NUMBER = "RENTAL_SEQUENCE_NUMBER";

	@Override
	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
		Class<? extends Object> clazz = object.getClass();
		Serializable generatedId = null;
		try {
			Method method = clazz.getMethod("getId", (Class<?>[]) null); //$NON-NLS-1$
			if (method != null) {
				Object id = method.invoke(object, (Object[]) null);
				if (id != null) {
					generatedId = (Serializable) id;
				}
			}

		} catch (Exception e) {
		}
		if (generatedId == null && object instanceof RentalLease) {
			RentalLease lease = (RentalLease) object;
			generatedId = generateOrderId((Session) session, lease.getCreatedDate());
		}
		else {
			generatedId = super.generateGlobalId();
		}
		return generatedId;
	}

	public static String generateLeaseId(RentalLease lease) {
		try (Session session = RentalLeaseDAO.getInstance().createNewSession()) {
			return generateOrderId(session, lease.getCreatedDate());
		}
	}

	private static String generateOrderId(Session session, Date createDate) {
		if (createDate == null) {
			createDate = new Date();
		}
		String prefix = "R" + SequenceNumber.yearMonthDayFormat.format(createDate); //$NON-NLS-1$
		String id = prefix
				+ SequenceNumber.threeDigitDecimalFormat.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(QUOTATION_SEQUENCE_NUMBER, prefix));
		while (RentalLeaseDAO.getInstance().get(id, session) != null) {
			id = prefix
					+ SequenceNumber.threeDigitDecimalFormat.format(SequenceNumberDAO.getInstance().getNextSequenceNumber(QUOTATION_SEQUENCE_NUMBER, prefix));
		}

		return id;
	}

}
