package com.floreantpos.model.util;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashRegister;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CashRegisterDAO;
import com.floreantpos.model.dao.GenericDAO;

public class TerminalUtil {

	public TerminalUtil() {
	}

	public static CashDrawer getActiveCurrentCashDrawer(String cashRegisterId) {

		CashRegister cashRegister = null;
		if (StringUtils.isNotBlank(cashRegisterId)) {
			cashRegister = CashRegisterDAO.getInstance().get(cashRegisterId);
		}
		//if (cashRegister == null) {
		//	cashRegister = createOrGetMainCashRegister();
		//}
		if (cashRegister != null) {
			String cashDrawerId = cashRegister.getCashDrawerId();
			if (StringUtils.isNotBlank(cashDrawerId)) {
				CashDrawer cashDrawer = CashDrawerDAO.getInstance().get(cashDrawerId);
				if (cashDrawer.isOpen()) {
					return cashDrawer;
				}
			}
		}

		return null;
	}

	public static CashRegister createOrGetMainCashRegister() {
		CashRegister mainRegister = CashRegisterDAO.getInstance().get("main-register"); //$NON-NLS-1$
		if (mainRegister == null) {
			mainRegister = new CashRegister("main-register"); //$NON-NLS-1$
			mainRegister.setName("Main register");
			if (StringUtils.isBlank(mainRegister.getOutletId())) {
				mainRegister.setOutletId(DataProvider.get().getOutletId());
			}
			CashRegisterDAO.getInstance().save(mainRegister);
		}
		return mainRegister;
	}

	public static void removeCashRegister(Terminal terminal) {

		String cashRegisterId = terminal.getCashRegisterId();
		if (StringUtils.isNotBlank(cashRegisterId)) {
			GenericDAO instance = GenericDAO.getInstance();

			Session session = null;
			Transaction tx = null;
			try {
				session = instance.createNewSession();
				tx = session.beginTransaction();

				CashRegister cashRegister = CashRegisterDAO.getInstance().get(cashRegisterId, session);
				cashRegister.setCashDrawerId(""); //$NON-NLS-1$
				instance.saveOrUpdate(cashRegister, session);

				tx.commit();
			} catch (Exception e) {
				if (tx != null) {
					tx.rollback();
				}
				throw e;
			} finally {
				instance.closeSession(session);
			}
		}
	}

}
