/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

import com.floreantpos.PosLog;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;

public class UpdateDBTo344 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo344(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void updateTickets() {
		PosLog.info(getClass(), "Updating " + schemaName + " schema.");
		DataProvider.get().initialize();
		try (Session session = sessionFactory.openSession()) {
		//@formatter:off
		
			Criteria criteria = session.createCriteria(Ticket.class);
			criteria.setProjection(Projections.rowCount());

			int rowCount = POSUtil.getInteger(criteria.uniqueResult());
			PosLog.info(getClass(), rowCount +" ticket found in " + schemaName + " schema.");
			int pageSize = 100;
			for (int i = 0; i < rowCount; i += pageSize) {
				criteria = session.createCriteria(Ticket.class);
				criteria.addOrder(Order.asc(Ticket.PROP_ID));
				criteria.setFirstResult(i);
				criteria.setMaxResults(pageSize);
				List<Ticket> tickets = criteria.list();
				Transaction transaction = session.beginTransaction();
				
				for (Ticket ticket : tickets) {
					ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId(), ticket.getOutletId(), session);
					List<TicketItem> ticketItems = ticket.getTicketItems();
					if (ticketItems != null) {
						for (TicketItem ticketItem : ticketItems) {
							String labTestId = ticketItem.getProperty("lab.test.id", "");
							if (StringUtils.isNotBlank(labTestId)) {
								ticketItem.setLabTestId(labTestId);
							}
						}
					}
					session.update(ticket);
				}
				transaction.commit();
			}
		}
	}
	
}