package com.floreantpos.model;

public enum Severity {
	LOW("Low"), MEDIUM("Medium"), HIGH("High");

	private String displayString;

	private Severity(String displayString) {
		this.displayString = displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static Severity fromString(String severityName) {
		Severity[] severities = values();
		for (Severity severity : severities) {
			if (severity.name().equals(severityName)) {
				return severity;
			}
		}
		return LOW;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}
}