package com.floreantpos.report.payout;

import java.util.Date;

import com.floreantpos.model.util.DateUtil;

public class PayoutReportData {

	private Date date;
	private String userId;
	private String userName;
	private String recipientId;
	private String recipientName;
	private String reasonId;
	private String reason;
	private String note;
	private Integer terminalId;
	private String terminalName;
	private String cashDrawerId;
	private double amount;

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getReasonId() {
		return reasonId;
	}

	public void setReasonId(String reasonId) {
		this.reasonId = reasonId;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getTerminalId() {
		return terminalId;
	}

	public void setTerminalId(Integer terminalId) {
		this.terminalId = terminalId;
	}

	public String getTerminalName() {
		return terminalName;
	}

	public void setTerminalName(String terminalName) {
		this.terminalName = terminalName;
	}

	public double getAmount() {
		return amount;
	}

	public void setAmount(double amount) {
		this.amount = amount;
	}

	public String getFormattedDate() {
		if (date == null) {
			return null;
		}
		return DateUtil.formatDateAsString(date);
	}

	public String getRecipientId() {
		return recipientId;
	}

	public void setRecipientId(String recipientId) {
		this.recipientId = recipientId;
	}

	public String getRecipientName() {
		return recipientName;
	}

	public void setRecipientName(String recipientName) {
		this.recipientName = recipientName;
	}

	public String getCashDrawerId() {
		return cashDrawerId;
	}

	public void setCashDrawerId(String cashDrawerId) {
		this.cashDrawerId = cashDrawerId;
	}

}