package com.floreantpos.util;

import org.json.JSONObject;

import com.google.gson.JsonObject;

public class OrgJsonUtil {
	public static String getString(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return null;
		}

		return jsonObject.getString(key);
	}

	public static Boolean getBoolean(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return false;
		}

		return jsonObject.getBoolean(key);
	}

	public static Integer getInt(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return 0;
		}

		return jsonObject.getInt(key);
	}

	public static Double getDouble(JSONObject jsonObject, String key) {
		if (!jsonObject.has(key)) {
			return 0.0;
		}

		return jsonObject.getDouble(key);
	}

	public static Double getDouble(JsonObject jsonObject, String key) {
		if (jsonObject.has(key)) {
			return jsonObject.get(key).getAsDouble();
		}
		return 0D;
	}

	public static String getString(JsonObject jsonObject, String key) {
		if (jsonObject.has(key)) {
			return jsonObject.get(key).getAsString();
		}
		return null;
	}
}
