/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;

public class UpdateDBTo301 {

	public void update() throws Exception {
		Session session = InventoryStockDAO.getInstance().createNewSession();
		Transaction transaction = session.beginTransaction();
		Query query = session.createQuery("delete from " + MenuItemInventoryStatus.REF);
		int updateCount = query.executeUpdate();
		transaction.commit();

		PosLog.info(getClass(), "Deleted " + updateCount + " row from menu item inventory status.");

		Map<MenuItemInventoryStatus, Double> outletWiseOnhandQuantity = new HashMap<MenuItemInventoryStatus, Double>();
		Criteria criteria = session.createCriteria(InventoryStock.class);

		ProjectionList projectionList = Projections.projectionList();
		projectionList.add(Projections.groupProperty(InventoryStock.PROP_MENU_ITEM_ID));
		projectionList.add(Projections.groupProperty(InventoryStock.PROP_OUTLET_ID));
		projectionList.add(Projections.groupProperty(InventoryStock.PROP_UNIT));
		projectionList.add(Projections.sum(InventoryStock.PROP_QUANTITY_IN_HAND));
		criteria.setProjection(projectionList);

		List<Object[]> list = criteria.list();
		for (Iterator<Object[]> iterator = list.iterator(); iterator.hasNext();) {
			Object[] objects = (Object[]) iterator.next();
			if (objects[0] == null) {
				continue;
			}

			String menuItemId = (String) objects[0];
			String outletId = (String) objects[1];
			if (StringUtils.isBlank(outletId)) {
				outletId = DataProvider.get().getStore().getDefaultOutletId();
			}
			String currrnetUnitName = (String) objects[2];
			if (StringUtils.isBlank(currrnetUnitName)) {
				currrnetUnitName = "ea";
			}
			double onHandQuantity = (objects[3] != null) ? ((Number) objects[3]).doubleValue() : 0;

			MenuItem menuItem = MenuItemDAO.getInstance().get(menuItemId, session);

			MenuItemInventoryStatus inventoryStatus = new MenuItemInventoryStatus();
			inventoryStatus.setMenuItemId(menuItemId);
			inventoryStatus.setOutletId(outletId);
			inventoryStatus.setUnitCode(menuItem.getUnit() == null ? "ea" : menuItem.getUnit().getId());

			double totalBaseUnit = InventoryUnitConvertionUtil.getBaseUnitQuantity(currrnetUnitName, menuItem) * onHandQuantity;
			Double oldValue = outletWiseOnhandQuantity.get(inventoryStatus);
			if (oldValue != null) {
				totalBaseUnit += oldValue;
			}

			outletWiseOnhandQuantity.put(inventoryStatus, totalBaseUnit);
		}
		session.close();

		if (outletWiseOnhandQuantity.isEmpty()) {
			return;
		}

		Set<MenuItemInventoryStatus> keySet = outletWiseOnhandQuantity.keySet();
		for (Iterator<MenuItemInventoryStatus> iterator = keySet.iterator(); iterator.hasNext();) {
			MenuItemInventoryStatus inventoryStatus = iterator.next();
			Double onHandUnit = outletWiseOnhandQuantity.get(inventoryStatus);
			inventoryStatus.setUnitOnHand(onHandUnit);
			inventoryStatus.setAvailableUnit(onHandUnit);

			PosLog.info(getClass(), String.format("Inventory status, item: %s, outlet: %s, unit: %s, on hand: %s", inventoryStatus.getMenuItemId(),
					inventoryStatus.getOutletId(), inventoryStatus.getUnitCode(), inventoryStatus.getUnitOnHand()));
			MenuItemInventoryStatusDAO.getInstance().save(inventoryStatus);
		}
	}
}