package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseInventoryStockUnit;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "uniqueCode" })
@XmlRootElement
public class InventoryStockUnit extends BaseInventoryStockUnit implements IUnit, TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public InventoryStockUnit() {
	}

	/**
	 * Constructor for primary key
	 */
	public InventoryStockUnit(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void calculateBaseUnitValue() {
		double conversionValue = getConversionValue();
		double unitFactor = getConversionRate();
		setBaseUnitValue(conversionValue / unitFactor);
	}

	@Override
	public String getUniqueCode() {
		return getName();
	}

	@Override
	public String toString() {
		return getName();
	}

	@Override
	public String getName() {
		return getPackagingName();
	}

	@Override
	public Double getConversionRate() {
		return super.getConversionValue() == 0 ? 1 : super.getConversionValue();
	}

	@Override
	public String getUnitType() {
		return UnitType.PACKAGING_UNIT.name();
	}

	@Override
	public String getDisplayName() {
		return StringUtils.isNotBlank(getName()) ? getName() : getUniqueCode();
	}
}