package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the APPOINTMENT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="APPOINTMENT"
 */

public abstract class BaseAppointment  implements Comparable, Serializable {

	public static String REF = "Appointment"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_APPOINMENT_ID = "appoinmentId"; //$NON-NLS-1$
	public static String PROP_PAID_AMOUNT = "paidAmount"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_APPOINTMENT_TYPE = "appointmentType"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CLOSED = "closed"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_SHIFT_ID = "shiftId"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_FROM_DATE = "fromDate"; //$NON-NLS-1$
	public static String PROP_TO_DATE = "toDate"; //$NON-NLS-1$
	public static String PROP_DOCTOR_FEE = "doctorFee"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PAYMENT_STATUS = "paymentStatus"; //$NON-NLS-1$


	// constructors
	public BaseAppointment () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseAppointment (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date fromDate;
				private java.util.Date toDate;
				private java.util.Date createdDate;
				private java.lang.String appointmentType;
				private java.lang.String appoinmentId;
				private java.lang.String shiftId;
				private java.lang.String patientId;
				private java.lang.String doctorId;
				private java.lang.Double doctorFee;
				private java.lang.String status;
				private java.lang.String paymentStatus;
				private java.lang.Double paidAmount;
				private java.lang.Boolean closed;
				private java.lang.String outletId;
				private java.lang.String userId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: FROM_DATE
	 */

	public java.util.Date getFromDate () {
			return fromDate;
	}



	/**
	 * Set the value related to the column: FROM_DATE
	 * @param fromDate the FROM_DATE value
	 */
			public void setFromDate (java.util.Date fromDate) {
			this.fromDate = fromDate;
	}



	/**
	 * Return the value associated with the column: TO_DATE
	 */

	public java.util.Date getToDate () {
			return toDate;
	}



	/**
	 * Set the value related to the column: TO_DATE
	 * @param toDate the TO_DATE value
	 */
			public void setToDate (java.util.Date toDate) {
			this.toDate = toDate;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: APPOINTMENT_TYPE
	 */

	public java.lang.String getAppointmentType () {
			return appointmentType;
	}



	/**
	 * Set the value related to the column: APPOINTMENT_TYPE
	 * @param appointmentType the APPOINTMENT_TYPE value
	 */
			public void setAppointmentType (java.lang.String appointmentType) {
			this.appointmentType = appointmentType;
	}



	/**
	 * Return the value associated with the column: APPOINTMENT_ID
	 */

	public java.lang.String getAppoinmentId () {
			return appoinmentId;
	}



	/**
	 * Set the value related to the column: APPOINTMENT_ID
	 * @param appoinmentId the APPOINTMENT_ID value
	 */
			public void setAppoinmentId (java.lang.String appoinmentId) {
			this.appoinmentId = appoinmentId;
	}
			
	/**
	 * Return the value associated with the column: SHIFT_ID
	 */

	public java.lang.String getShiftId () {
			return shiftId;
	}



	/**
	 * Set the value related to the column: SHIFT_ID
	 * @param shiftId the SHIFT_ID value
	 */
			public void setShiftId (java.lang.String shiftId) {
			this.shiftId = shiftId;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_FEE
	 */

	public java.lang.Double getDoctorFee () {
						return doctorFee == null ? Double.valueOf(0) : doctorFee;
		}



	/**
	 * Set the value related to the column: DOCTOR_FEE
	 * @param doctorFee the DOCTOR_FEE value
	 */
			public void setDoctorFee (java.lang.Double doctorFee) {
			this.doctorFee = doctorFee;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: PAYMENT_STATUS
	 */

	public java.lang.String getPaymentStatus () {
			return paymentStatus;
	}



	/**
	 * Set the value related to the column: PAYMENT_STATUS
	 * @param paymentStatus the PAYMENT_STATUS value
	 */
			public void setPaymentStatus (java.lang.String paymentStatus) {
			this.paymentStatus = paymentStatus;
	}



	/**
	 * Return the value associated with the column: PAID_AMOUNT
	 */

	public java.lang.Double getPaidAmount () {
						return paidAmount == null ? Double.valueOf(0) : paidAmount;
		}



	/**
	 * Set the value related to the column: PAID_AMOUNT
	 * @param paidAmount the PAID_AMOUNT value
	 */
			public void setPaidAmount (java.lang.Double paidAmount) {
			this.paidAmount = paidAmount;
	}



	/**
	 * Return the value associated with the column: CLOSED
	 */

	public java.lang.Boolean isClosed () {
					return closed == null ? Boolean.FALSE : closed;
		}

	public java.lang.Boolean getClosed () {
				return closed == null ? Boolean.FALSE : closed;
			}


	/**
	 * Set the value related to the column: CLOSED
	 * @param closed the CLOSED value
	 */
			public void setClosed (java.lang.Boolean closed) {
			this.closed = closed;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Appointment)) return false;
		else {
			com.floreantpos.model.Appointment appointment = (com.floreantpos.model.Appointment) obj;
			if (null == this.getId() || null == appointment.getId()) return this == obj;
			else return (this.getId().equals(appointment.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}