package com.floreantpos.model.ext;

import com.floreantpos.Messages;

public enum DiscountCondition {

	FIRST_ORDER_ON_STORE(Messages.getString("FirstOrderOnStore")); //$NON-NLS-1$

	private final String name;

	DiscountCondition(String name) {
		this.name = name;
	}

	public String value() {
		return name;
	}

	public static DiscountCondition fromValue(String name) {
		for (DiscountCondition dc : DiscountCondition.values()) {
			if (dc.name().equals(name)) {
				return dc;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return name;
	}

}