package com.floreantpos.model;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePriceTable;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "lastUpdatedBy" })
@XmlRootElement
public class PriceTable extends BasePriceTable implements TimedModel {
	private static final long serialVersionUID = 1L;
	private List<PriceTableItem> priceTableItems;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PriceTable() {
	}

	/**
	 * Constructor for primary key
	 */
	public PriceTable(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	@Override
	public String toString() {
		return super.getName();
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public void setPriceTableItems(List<PriceTableItem> items) {
		this.priceTableItems = items;
	}

	public List<PriceTableItem> getPriceTableItems() {
		return priceTableItems;
	}
}