package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MACHINE_RESULT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MACHINE_RESULT"
 */

public abstract class BaseMachineResult  implements Serializable {

	public static String REF = "MachineResult"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_RESULT_JSON = "resultJson"; //$NON-NLS-1$
	public static String PROP_STORE_ID = "storeId"; //$NON-NLS-1$
	public static String PROP_STORE_NAME = "storeName"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_STORE_SCHEMA = "storeSchema"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_SAMPLE_ID = "sampleId"; //$NON-NLS-1$
	public static String PROP_RESULT_DATE = "resultDate"; //$NON-NLS-1$


	// constructors
	public BaseMachineResult () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMachineResult (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date resultDate;
				private java.lang.String storeId;
				private java.lang.String storeSchema;
				private java.lang.String storeName;
				private java.lang.String outletId;
				private java.lang.String sampleId;
				private java.lang.String resultJson;
				private java.lang.String properties;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: RESULT_DATE
	 */

	public java.util.Date getResultDate () {
			return resultDate;
	}



	/**
	 * Set the value related to the column: RESULT_DATE
	 * @param resultDate the RESULT_DATE value
	 */
			public void setResultDate (java.util.Date resultDate) {
			this.resultDate = resultDate;
	}



	/**
	 * Return the value associated with the column: STORE_ID
	 */

	public java.lang.String getStoreId () {
			return storeId;
	}



	/**
	 * Set the value related to the column: STORE_ID
	 * @param storeId the STORE_ID value
	 */
			public void setStoreId (java.lang.String storeId) {
			this.storeId = storeId;
	}



	/**
	 * Return the value associated with the column: STORE_SCHEMA
	 */

	public java.lang.String getStoreSchema () {
			return storeSchema;
	}



	/**
	 * Set the value related to the column: STORE_SCHEMA
	 * @param storeSchema the STORE_SCHEMA value
	 */
			public void setStoreSchema (java.lang.String storeSchema) {
			this.storeSchema = storeSchema;
	}



	/**
	 * Return the value associated with the column: STORE_NAME
	 */

	public java.lang.String getStoreName () {
			return storeName;
	}



	/**
	 * Set the value related to the column: STORE_NAME
	 * @param storeName the STORE_NAME value
	 */
			public void setStoreName (java.lang.String storeName) {
			this.storeName = storeName;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: SAMPLE_ID
	 */

	public java.lang.String getSampleId () {
			return sampleId;
	}



	/**
	 * Set the value related to the column: SAMPLE_ID
	 * @param sampleId the SAMPLE_ID value
	 */
			public void setSampleId (java.lang.String sampleId) {
			this.sampleId = sampleId;
	}



	/**
	 * Return the value associated with the column: RESULT_JSON
	 */

	public java.lang.String getResultJson () {
			return resultJson;
	}



	/**
	 * Set the value related to the column: RESULT_JSON
	 * @param resultJson the RESULT_JSON value
	 */
			public void setResultJson (java.lang.String resultJson) {
			this.resultJson = resultJson;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MachineResult)) return false;
		else {
			com.floreantpos.model.MachineResult machineResult = (com.floreantpos.model.MachineResult) obj;
			if (null == this.getId() || null == machineResult.getId()) return this == obj;
			else return (this.getId().equals(machineResult.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}