package com.floreantpos.report.model;

import com.floreantpos.report.ItemwiseRfReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class ItemWiseRFReportModel extends ListTableModel {
	public ItemWiseRFReportModel() {
		super(new String[] { "orderId", "itemName", "itemPrice", "itemDiscount", "itemTax", "rfDisplayName", "rf", "nonRf", "labDoctorFee", "net",
				"rfOnNetDisplay", "rfOnNetSalesDisplay", "finalNet","rfOnNetSales" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		ItemwiseRfReportData reportData = (ItemwiseRfReportData) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return reportData.getOrderId();

			case 1:
				return reportData.getDisplayItemName();

			case 2:
				return NumberUtil.formatNumber(reportData.getItemPrice());

			case 3:
				return NumberUtil.formatNumber(reportData.getItemDiscount());

			case 4:
				return NumberUtil.formatNumber(reportData.getItemTax());

			case 5:
				return reportData.getRfDisplayName();

			case 6:
				return NumberUtil.formatNumber(reportData.getRf());

			case 7:
				return NumberUtil.formatNumber(reportData.getNonRf());

			case 8:
				return NumberUtil.formatNumber(reportData.getLabDoctorFee());

			case 9:
				return NumberUtil.formatNumber(reportData.getNet());

			case 10:
				return reportData.getRfOnNetDisplay();

			case 11:
				return reportData.getRfOnNetSalesDisplay();

			case 12:
				return NumberUtil.formatNumber(reportData.getFinalNet());
				
			case 13:
				return reportData.getRfOnNetSales();

		}
		return null;
	}

}