/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class PayoutReportDataModel extends ListTableModel {

	public PayoutReportDataModel() {
		setColumnNames(new String[] { "date", "user", "recipient", "reason", "note", "batchNo", "amount", "payoutID" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		PayOutTransaction data = (PayOutTransaction) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return DateUtil.formatReportDateWithBrowserTimeOffset(data.getTransactionTime());

			case 1:
				return data.getUserName();

			case 2:
				return data.getRecepientDisplay();

			case 3:
				return data.getReasonDisplay();

			case 4:
				return data.getNote();

			case 5:
				return StringUtils.isNotBlank(data.getBatchNo()) ? data.getBatchNo().trim() : data.getBatchNo();

			case 6:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getAmount());

			case 7:
				return data.getId();

		}
		return null;
	}

}
