package com.floreantpos.model;

import java.util.Arrays;
import java.util.List;

public enum AccountHistoryType {
	//@formatter:off
    MQTT_CHECK(ActionHistory.MQTT_CHECK, "Mqtt ticket save"),
    NEW_CHECK(ActionHistory.NEW_CHECK, "created order %s"),
    SAVE_CHECK(ActionHistory.SAVE_CHECK, "saved order %s"),
    EDIT_CHECK(ActionHistory.EDIT_CHECK, "edited order %s"),
    SPLIT_CHECK(ActionHistory.SPLIT_CHECK, "splited order %s"),
    VOID_CHECK(ActionHistory.VOID_CHECK, "voided order %s"),
    VOID_PAYMENT(ActionHistory.VOID_PAYMENT, "voided payment in order %s"),
    NEW_PURCHASE_ORDER(ActionHistory.NEW_PURCHASE_ORDER, "New purchase order"),
    TICKET_ITEM_VOID(ActionHistory.TICKET_ITEM_VOID, "Order item void"),
    REOPEN_CHECK(ActionHistory.REOPEN_CHECK, "reopen order %s"),
    SETTLE_CHECK(ActionHistory.SETTLE_CHECK, "settle order %s"),
    REFUND_CHECK(ActionHistory.REFUND_CHECK, "refund order %s"),
    PRINT_CHECK(ActionHistory.PRINT_CHECK, "Print receipt"),
    PAY_CHECK(ActionHistory.PAY_CHECK, "Pay order"),
    GROUP_SETTLE(ActionHistory.GROUP_SETTLE, "Group settle"),
    PAY_OUT(ActionHistory.PAY_OUT, "Pay out"),
    EXPENSES(ActionHistory.EXPENSES, "Expenses"),
    SALARY(ActionHistory.SALARY, "Salary"),
    RF_PAY(ActionHistory.RF_PAY, "RF pay"),
    LDF_PAY(ActionHistory.LDF_PAY, "LDF pay"),
    PAY_TIPS(ActionHistory.PAY_TIPS, "Pay tips"),
    STAFF_BANK_FORCE_CLOSE(ActionHistory.STAFF_BANK_FORCE_CLOSE, "Staff bank force close"),
    TRANSFER_TICKET(ActionHistory.TRANSFER_TICKET, "Transfer ticket"),
    SENT_TO_KITCHEN(ActionHistory.SENT_TO_KITCHEN, "Sent to kitchen"),
    FORCED_CLOCK_OUT(ActionHistory.FORCED_CLOCK_OUT, "Forced clock out"),
    CLOCK_IN(ActionHistory.CLOCK_IN, "Clock in"),
    CLOCK_OUT(ActionHistory.CLOCK_OUT, "Clock out"),
    DATE_CHANGE(ActionHistory.DATE_CHAGE, "Order create date change"),
    CUSTOMER_SET(ActionHistory.CUSTOMER_SET, "Customer set"),
    CUSTOMER_REMOVED(ActionHistory.CUSTOMER_REMOVED, "Customer removed"),
    MERGE_TICKET(ActionHistory.MERGE_TICKET, "Merge ticket"),
    TRANSFER_ITEMS(ActionHistory.TRANSFER_ITEMS, "Transfer items"),
    TABLE_CHANGE(ActionHistory.TABLE_CHANGE, "Table change"),
    TABLE_ADDED(ActionHistory.TABLE_ADDED, "Table added"),
    TABLE_RELEASED(ActionHistory.TABLE_RELEASED, "Table released"),
    SALES_AREA_CHANGE(ActionHistory.SALES_AREA_CHANGE, "Sales area change"),
    ORDER_HOLD(ActionHistory.ORDER_HOLD, "hold order %s"),
    CASH_DRAWER_CLOSE(ActionHistory.CASH_DRAWER_CLOSE, "cash drawer has been closed"),
    CASH_DRAWER_ASSIGNMENT(ActionHistory.CASH_DRAWER_ASSIGNMENT, "cash drawer has been opened"),
    CLOSE_TICKET(ActionHistory.CLOSE_TICKET, "close order %s"),
    TICKET_DISCOUNT_ADDED(ActionHistory.TICKET_DISCOUNT_ADDED, "order discount added in order %s"),
    ITEM_DISCOUNT_ADDED(ActionHistory.ITEM_DISCOUNT_ADDED, "item discount added in order %s"),
    LOYALTY_ADDED(ActionHistory.LOYALTY_ADDED, "Loyalty added"),
    TICKET_DISCOUNT_REMOVED(ActionHistory.TICKET_DISCOUNT_REMOVED, "order discount removed in order %s"),
    ITEM_DISCOUNT_REMOVED(ActionHistory.ITEM_DISCOUNT_REMOVED, "item discount removed in order %s"),
    LOYALTY_REMOVED(ActionHistory.LOYALTY_REMOVED, "Loyalty removed"),
    //GRATUITY_ADDED(ActionHistory.GRATUITY_ADDED, "Gratuity set"),
    //SF_SYNC_GRATUITY_CHANGE(ActionHistory.SF_SYNC_GRATUITY_CHANGE, "Sf sync gratuity amount change"),
    TAX_EXEMPT(ActionHistory.TAX_EXEMPT, "Tax exempt"),
    TAX_UNEXEMPT(ActionHistory.TAX_UNEXEMPT, "Tax unexempt"),
    CASH_DRAWER_BLEED(ActionHistory.CASH_DRAWER_BLEED, "Cash drawer bleed"),
    CASH_DRAWER_TRANSFER_USER(ActionHistory.CASH_DRAWER_TRANSFER_USER, "Cash drawer assignment change"),
    USER_CREATED(ActionHistory.USER_CREATED, "user created"),
    USER_MODIFIED(ActionHistory.USER_MODIFIED, "user modified"),
    USER_DELETED(ActionHistory.USER_DELETED, "user deleted"),
    TICKET_DELETED(ActionHistory.TICKET_DELETED, "Ticket deleted"),
    ADJUST_INVENTORY_ON_HAND(ActionHistory.ADJUST_INVENTORY_ON_HAND, "Adjust inventory on hand"),
    PURCHASE_ITEM_ADDED(ActionHistory.PURCHASE_ITEM_ADDED, "Purchase Item added"),
    PURCHASE_ITEM_EDITED(ActionHistory.PURCHASE_ITEM_EDITED, "Purchase Item edited"),
    PURCHASE_ITEM_DELETED(ActionHistory.PURCHASE_ITEM_DELETED, "Purchase Item deleted"),
    ITEM_ADDED(ActionHistory.ITEM_ADDED, "added item %s in order %s"),
    ITEM_EDITED(ActionHistory.ITEM_EDITED, "edited item %s in order %s"),
    ITEM_DELETED(ActionHistory.ITEM_DELETED, "deleted item  %s in order %s"),
    PATIENT_ADDED(ActionHistory.PATIENT_ADDED, "added patient in order %s"),
    PATIENT_DELETED(ActionHistory.PATIENT_DELETED, "deleted patient in order %s"),
    DOCTOR_ADDED(ActionHistory.DOCTOR_ADDED, "added doctor in order %s"),
    REFERRER_ADDED(ActionHistory.REFERRER_ADDED, "added referrer in order %s"),
    REFERRER_CHANGED(ActionHistory.REFERRER_CHANGED, "referrer changed in order %s"),
    OPEN_REGISTER(ActionHistory.OPEN_REGISTER, "Open register"),
    CLOSE_REGISTER(ActionHistory.CLOSE_REGISTER, "Close register"),
    USER_LOGIN(ActionHistory.USER_LOGIN, "logs in"),
    USER_LOGOUT(ActionHistory.USER_LOGOUT, "logs out"),
    LAB_INCHARGE_ADDED(ActionHistory.LAB_INCHARGE_ADDED, "Lab incharge added"),
    ORDER_INFO(ActionHistory.ORDER_INFO, "VIEW ORDER INFO"),
    RECIPE_ITEMS_PRINT(ActionHistory.RECIPE_ITEMS_PRINT, "RECIPE ITEMS PRINT"),
    DONT_UPDATE_RECIPE_ITEMS(ActionHistory.DONT_UPDATE_RECIPE_ITEMS, "DON'T UPDATE RECIPE ITEMS"),
    VIEW_REPORT(ActionHistory.VIEW_REPORT, "VIEW REPORT"),
    PRINT_LAB_REPORT(ActionHistory.PRINT_LAB_REPORT, "PRINT LAB REPORT"),
    PRINT_INVOICE(ActionHistory.PRINT_INVOICE, "PRINT INVOICE"),
    PRINT_STICKER(ActionHistory.PRINT_STICKER, "PRINT STICKER"),
    CLOSE_ORDER(ActionHistory.CLOSE_ORDER, "CLOSE ORDER"),
    CREATE_CUSTOMER(ActionHistory.CREATE_CUSTOMER, "Customer created"),
    EDIT_CUSTOMER(ActionHistory.EDIT_CUSTOMER, "Customer Edited"),
    CREATE_PATIENT(ActionHistory.CREATE_PATIENT, "Patient created"),
    EDIT_PATIENT(ActionHistory.EDIT_PATIENT, "Patient Edited"),
    CREATE_DOCTOR(ActionHistory.CREATE_DOCTOR, "Doctor created"),
    EDIT_DOCTOR(ActionHistory.EDIT_DOCTOR, "Doctor edited"),
    DOCTOR_DELETED(ActionHistory.DOCTOR_DELETED, "Doctor deleted"),
    CREATE_AGENT(ActionHistory.CREATE_AGENT, "Agent created"),
    EDIT_AGENT(ActionHistory.EDIT_AGENT, "Agent edited"),
    AGENT_DELETED(ActionHistory.AGENT_DELETED, "Agent deleted"),
    USER_PASSWORD_CHANGED(ActionHistory.USER_PASSWORD_CHANGED, "User password changed"),
    USER_PIN_CHANGED(ActionHistory.USER_PIN_CHANGED, "User pin changed"),
    PRICE_UPDATED(ActionHistory.PRICE_UPDATED, "Price updated due to RF change"),
    APPOINTMENT_DELETED(ActionHistory.APPOINTMENT_DELETED, "Appointment deleted"),
    CREATE_APPOINTMENT(ActionHistory.CREATE_APPOINTMENT, "Appointment created"),
    CHANGED_CUSTOMER("Changed customer", "customer changed in order %s"),
    RECEIVE_PURCHASE_ORDER("Receive purchase order", "Receive purchase order"),
    STOCK_IN("Stock IN", "Stock IN"),
    CONFIRM_PURCHASE_ORDER("Confirm purchase order", "Confirm purchase order"),
    CREATE_MEDICINE_PURCHASE_ORDER("Create medicine purchase order", "Create medicine purchase order"),
    PACKAGING_UNIT("Packaging unit", "Packaging unit"),
    RECIPE_ITEM_EDIT("Recipe item edit", "Recipe item edit"),
    CLOSE_DRAWER("Close Drawer", "Close Drawer"),
    BLOOD_TRANSACTION_CREATED("Blood transaction created", "Blood transaction created"),
    BLOOD_REQUEST_CREATED("Blood request created", "Blood request created"),
    DONOR_CREATED("Donor created", "Donor created"),
    LAB_DOCTOR_UPDATED("Lab doctor updated", "Lab doctor updated"),
    STOCK_OUT("Stock OUT", "Stock OUT"),
    LAB_WORK_RESULT_RECORDED("Lab work Result recorded", "Lab work Result recorded"),
    LAB_WORK_SAMPLE_COLLECTED("Lab work Sample collected", "Lab work Sample collected"),
    LAB_WORK_RUN_TEST("Lab work Run test", "Lab work Run test")
    ;
    //@formatter:on

	private final String value;
	private final String displayString;

	AccountHistoryType(String value, String displayString) {
		this.value = value;
		this.displayString = displayString;
	}

	public String getValue() {
		return value;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static AccountHistoryType getAccountHistoryType(String actionName) {
		for (AccountHistoryType type : AccountHistoryType.values()) {
			if (type.getValue().equals(actionName)) {
				return type;
			}
		}
		return null;
	}

	public static String actionNameDisplay(String actionName) {
		for (AccountHistoryType type : AccountHistoryType.values()) {
			if (type.getValue().equals(actionName)) {
				return type.getDisplayString();
			}
		}
		return null;
	}

	public static List<AccountHistoryType> getOrderTypeHistories() {
		return Arrays.asList(NEW_CHECK, SAVE_CHECK, EDIT_CHECK, SPLIT_CHECK, VOID_CHECK, PATIENT_ADDED, PATIENT_DELETED, DOCTOR_ADDED, REFERRER_ADDED,
				REFERRER_CHANGED, TICKET_DISCOUNT_ADDED, TICKET_DISCOUNT_REMOVED, ITEM_DISCOUNT_ADDED, ITEM_DISCOUNT_REMOVED, CLOSE_TICKET, ORDER_HOLD,
				REOPEN_CHECK, REFUND_CHECK, SETTLE_CHECK, VOID_PAYMENT, CHANGED_CUSTOMER);
	}

	public static List<AccountHistoryType> getOrderItemTypeHistories() {
		return Arrays.asList(ITEM_ADDED, ITEM_EDITED, ITEM_DELETED);
	}
}
