/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import java.util.Calendar;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;
import com.floreantpos.model.base.BaseShift;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "dayOfWeekAsString" })
@XmlSeeAlso({ PriceShift.class, DayPart.class, StoreHour.class, EmployeeShift.class, DataSync.class, MiscShift.class, MenuShift.class, ReservationShift.class })
@XmlRootElement(name = "shift")
@JsonTypeInfo(use = Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "classType")
@JsonSubTypes({ @Type(value = PriceShift.class), @Type(value = DayPart.class), @Type(value = StoreHour.class), @Type(value = EmployeeShift.class),
		@Type(value = DataSync.class), @Type(value = MiscShift.class), @Type(value = MenuShift.class), @Type(value = ReservationShift.class) })
public class Shift extends BaseShift implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$

	private java.util.Date startTime;
	private java.util.Date endTime;
	private String classType;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Shift() {
	}

	/**
	 * Constructor for primary key
	 */
	public Shift(java.lang.String id, java.lang.String outletId) {

		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public Shift(java.lang.String id, java.lang.String outletId, java.lang.String name) {

		super(id, outletId, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public Long getShiftLength() {
		Long shiftLength2 = super.getShiftLength();
		if (shiftLength2 == null) {
			return Math.abs(getStartTime().getTime() - getEndTime().getTime());
		}
		return shiftLength2;
	}

	public java.util.Date getStartTime() {
		if (startTime == null) {
			Calendar c = Calendar.getInstance();
			c.clear();
			c.set(Calendar.HOUR_OF_DAY, super.getStartHour());
			c.set(Calendar.MINUTE, super.getStartMin());
			startTime = c.getTime();
		}
		return startTime;
	}

	public void setStartTime(java.util.Date startTime) {
		this.startTime = startTime;
		if (startTime != null) {
			Calendar c = Calendar.getInstance();
			c.setTime(startTime);
			super.setStartHour(c.get(Calendar.HOUR_OF_DAY));
			super.setStartMin(c.get(Calendar.MINUTE));
		}
	}

	public java.util.Date getEndTime() {
		if (endTime == null) {
			Calendar c = Calendar.getInstance();
			c.clear();
			c.set(Calendar.HOUR_OF_DAY, super.getEndHour());
			c.set(Calendar.MINUTE, super.getEndMin());
			endTime = c.getTime();
		}
		return endTime;
	}

	public void setEndTime(java.util.Date endTime) {
		this.endTime = endTime;
		if (endTime != null) {
			Calendar c = Calendar.getInstance();
			c.setTime(endTime);
			super.setEndHour(c.get(Calendar.HOUR_OF_DAY));
			super.setEndMin(c.get(Calendar.MINUTE));
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof Shift))
			return false;

		return getName().equalsIgnoreCase(((Shift) obj).getName());
	}

	public String getClassType() {
		if (classType == null) {
			return classType = getClass().getSimpleName();
		}
		return classType;
	}

	public void setClassType(String classType) {
		this.classType = classType;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public String toString() {
		return getName();
	}
}