package com.orocube.medlogics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;

public enum Module {
	FRONT_DESK("Diagnostics front desk", true, UserPermission.DIAGONSTICS_FRONT_DESK),
	DIAGNOSTICS_LAB("Diagnostics Lab", true, UserPermission.DIAGONSTICS_LAB),//Permission: Lab works
	PHARMACY("Pharmacy", true, UserPermission.PHARMACY),
	IPD("IPD", true, UserPermission.IPD),//future
	OPD("OPD", true, UserPermission.OPD),//appointment
	HOTEL_MANAGEMENT("Hotel management", true, UserPermission.HOTEL_MANAGEMENT),
	INVENTORY("Inventory", false, null),
	REFERRAL("Referral", false, UserPermission.REFERRAL);
	
	private String displayString;
	private boolean standalone;
	private UserPermission requirdPermission;
	
	private Module(String displayString, boolean standalone, UserPermission permission) {
		this.displayString = displayString;
		this.standalone = standalone;
		this.requirdPermission = permission;
	}

	public String getDisplayString() {
		return displayString;
	}

	public boolean isStandalone() {
		return standalone;
	}
	
	public static Module fromDisplayString(String displayString) {
		Module[] values = values();
		for (Module module : values) {
			if (module.getDisplayString().equals(displayString)) {
				return module;
			}
		}
		return null;
	}
	
	public static List<Module> getStandAloneModules() {
		List<Module> standAloneModules = new ArrayList<Module>();
		for (Module module : values()) {
			if (module.isStandalone()) {
				standAloneModules.add(module);
			}
		}
		Comparator<Module> comparator = Comparator.comparing(Module::toString, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
		standAloneModules.sort(comparator);
		return standAloneModules;

	}
	
	public boolean hasPermission(User user) {
		if (requirdPermission == null) {
			return true;
		}
		
		return user.hasPermission(requirdPermission);
	}
	
	@Override
	public String toString() {
		return getDisplayString();
	}
}
