package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.ConsentTemplate;


public class ConsentTemplateDAO extends BaseConsentTemplateDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ConsentTemplateDAO () {}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public void delete(Object obj, Session s) throws HibernateException {
		ConsentTemplate template = (ConsentTemplate) obj;
		template.setDeleted(true);
		update(template, s);
	}

	public ConsentTemplate findConsentTemplateByType(String consentType, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(ConsentTemplate.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(ConsentTemplate.PROP_CONSENT_TYPE, consentType));
			if (StringUtils.isNotBlank(outletId)) {
				criteria.add(Restrictions.eq(ConsentTemplate.PROP_OUTLET_ID, outletId));
			}
			List list = criteria.list();
			if (!list.isEmpty()) {

				return (ConsentTemplate) list.get(0);
			}
		}
		return null;
	}

}