package com.floreantpos.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

import org.imgscalr.Scalr;

import com.floreantpos.PosLog;
import com.floreantpos.report.ReportUtil;

public class ImageUtil {

	public static String IMAGE_FORMAT_PNG = "png";

	public static byte[] convertImageToByteArray(BufferedImage image) throws IOException {
		try (ByteArrayOutputStream baos = new ByteArrayOutputStream()) {
			ImageIO.write(image, IMAGE_FORMAT_PNG, baos);
			baos.flush();
			return baos.toByteArray();
		}
	}

	public static BufferedImage reduceImageFileSize(BufferedImage image, int size) throws IOException {
		BufferedImage resize = Scalr.resize(image, size, (BufferedImageOp) null);
		byte[] imageToByteArray = convertImageToByteArray(resize);
		int imageSize = imageToByteArray.length / 1024;

		if (imageSize > 1000) {
			return reduceImageFileSize(image, size / 2);
		}
		return resize;
	}

	public static ImageIcon pngToJpg(ImageIcon imageIcon) {
		Image image = imageIcon.getImage();
		BufferedImage bimage1 = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), BufferedImage.TYPE_3BYTE_BGR);

		BufferedImage bimage = bimage1;
		if (bimage1.getTransparency() != BufferedImage.OPAQUE) {
			int w = bimage1.getWidth();
			int h = bimage1.getHeight();
			int[] pixels = new int[w * h];
			bimage1.getRGB(0, 0, w, h, pixels, 0, w);
			bimage = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
			bimage.setRGB(0, 0, w, h, pixels, 0, w);
		}

		// Draw the image on to the buffered image
		Graphics2D bGr = bimage.createGraphics();
		bGr.setColor(Color.white);
		bGr.fillRect(0, 0, bimage.getWidth(), bimage.getHeight());
		bGr.drawImage(image, 0, 0, null);
		bGr.dispose();

		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		try {
			ImageIO.write(bimage, "jpeg", outputStream);
		} catch (IOException e) {
			PosLog.error(ReportUtil.class, e);
			return null;
		}

		return new ImageIcon(outputStream.toByteArray());
	}
}
