package com.floreantpos;

import org.slf4j.LoggerFactory;

public class PosLog {

	public static void error(Class<?> eClass, String message) {
		LoggerFactory.getLogger(eClass).error(message);
	}

	public static void error(Class<?> eClass, Exception e) {
		String message = e.getMessage();
		LoggerFactory.getLogger(eClass).error(message, e);
	}

	public static void error(Class<?> eClass, String message, Exception e) {
		LoggerFactory.getLogger(eClass).error(message, e);
	}

	public static void debug(Class<?> eClass, Exception e) {
		String message = e.getMessage();
		LoggerFactory.getLogger(eClass).debug(message, e);
	}

	public static void debug(Class<?> eClass, String message) {
		LoggerFactory.getLogger(eClass).debug(message);
	}

	public static void info(Class<?> eClass, String message) {
		LoggerFactory.getLogger(eClass).info(message);
	}
}
