package com.floreantpos.model;

public enum PatientBookingStatus {
	ACTIVE("Active", 0), DISCHARGED("Discharged", 1);
	private String displayString;
	private int index;

	private PatientBookingStatus(String displayString, int index) {
		this.displayString = displayString;
		this.index = index;
	}

	public int getIndex() {
		return index;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static PatientBookingStatus fromNameString(String name) {
		PatientBookingStatus[] statusList = values();
		for (PatientBookingStatus status : statusList) {
			if (status.name().equals(name)) {
				return status;
			}
		}
		return PatientBookingStatus.ACTIVE;
	}

	@Override
	public String toString() {
		return getDisplayString();
	}

}