package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the STORE_SESSION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="STORE_SESSION"
 */

public abstract class BaseStoreSession  implements Comparable, Serializable {

	public static String REF = "StoreSession"; //$NON-NLS-1$
	public static String PROP_OPEN_TIME = "openTime"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_CLOSE_TIME = "closeTime"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CLOSED_BY_USER_ID = "closedByUserId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_OPENED_BY_USER_ID = "openedByUserId"; //$NON-NLS-1$


	// constructors
	public BaseStoreSession () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseStoreSession (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date openTime;
				private java.util.Date closeTime;
				private java.lang.String outletId;
				private java.lang.String openedByUserId;
				private java.lang.String closedByUserId;
				private java.lang.Boolean cloudSynced;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OPEN_TIME
	 */

	public java.util.Date getOpenTime () {
			return openTime;
	}



	/**
	 * Set the value related to the column: OPEN_TIME
	 * @param openTime the OPEN_TIME value
	 */
			public void setOpenTime (java.util.Date openTime) {
			this.openTime = openTime;
	}



	/**
	 * Return the value associated with the column: CLOSE_TIME
	 */

	public java.util.Date getCloseTime () {
			return closeTime;
	}



	/**
	 * Set the value related to the column: CLOSE_TIME
	 * @param closeTime the CLOSE_TIME value
	 */
			public void setCloseTime (java.util.Date closeTime) {
			this.closeTime = closeTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: OPEN_BY_USER
	 */

	public java.lang.String getOpenedByUserId () {
			return openedByUserId;
	}



	/**
	 * Set the value related to the column: OPEN_BY_USER
	 * @param openedByUserId the OPEN_BY_USER value
	 */
			public void setOpenedByUserId (java.lang.String openedByUserId) {
			this.openedByUserId = openedByUserId;
	}



	/**
	 * Return the value associated with the column: CLOSE_BY_USER
	 */

	public java.lang.String getClosedByUserId () {
			return closedByUserId;
	}



	/**
	 * Set the value related to the column: CLOSE_BY_USER
	 * @param closedByUserId the CLOSE_BY_USER value
	 */
			public void setClosedByUserId (java.lang.String closedByUserId) {
			this.closedByUserId = closedByUserId;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.StoreSession)) return false;
		else {
			com.floreantpos.model.StoreSession storeSession = (com.floreantpos.model.StoreSession) obj;
			if (null == this.getId() || null == storeSession.getId()) return this == obj;
			else return (this.getId().equals(storeSession.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}