package com.floreantpos.report;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.ProductType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.DoctorDAO;
import com.floreantpos.model.util.DateUtil;

public class LabDoctorFeeReportData implements Serializable {

	private String id;
	private String orderId;
	private Date orderDate;
	//private String orderDateDisplay;
	private String outletId;
	private String patientName;
	private String patientId;
	private String testName;
	private String labDoctorId;
	private String labDoctorName;
	private String labDoctorDepartment;
	private String labDoctorPhone;
	private String productType;
	private String serviceType;
	private String menuItemId;

	private double labDoctorFee;
	private double labDoctorFeeSubtotal;
	private double ticketItemAdjustedDiscount;
	private double grossSaleAmount;
	private double labDoctorFeePaidAmount;
	private double labDoctorFeeDueAmount;
	private double labDoctorFeeDiscountAmount;
	private double othersAmount;
	private double consumableItemAmount;

	private boolean isRevisitFeeApplicable;
	private int oldTicketCount;
	private int newTicketCount;
	private int count;

	public LabDoctorFeeReportData() {

	}

	public LabDoctorFeeReportData(Ticket ticket, TicketItem ticketItem) {
		setId(ticketItem.getParentTicketId());
		setOrderId(ticketItem.getParentTicketId());
		setOrderDate(ticket.getCreateDate());
		setOutletId(ticketItem.getParentTicketOutletId());
		setProductType(ticketItem.getProductType());
		setServiceType(ticketItem.getServiceType());
		setMenuItemId(ticketItem.getMenuItemId());

		String doctorId = ticketItem.getLabDoctorId();
		Doctor doctor = doctorId == null ? null : DoctorDAO.getInstance().get(doctorId);
		if (StringUtils.isNotBlank(doctorId)) {
			setLabDoctorId(doctorId);
			if (doctor != null) {
				setLabDoctorName(doctor.getName());
				String departmentName = doctor.getDepartmentName();
				if (departmentName != null) {
					setLabDoctorDepartment(departmentName);
				}
				String phone = doctor.getMobileNo();
				if (phone != null) {
					setLabDoctorPhone(phone);
				}
			}
		}

		setTestName(ticketItem.getName());
		setLabDoctorFeePaidAmount(ticketItem.getLabDoctorFeePaidAmount());
		setRevisitFeeApplicable(ticketItem.isRevisitFeeApplicable());

		setGrossSaleAmount(ticketItem.getSubtotalAmount());
		Double labDoctorFee = ticketItem.getLabDoctorFee();
		double doctorFeeDiscountAmount = ticketItem.getDoctorFeeDiscountAmount();

		setLabDoctorFeeSubtotal(labDoctorFee + doctorFeeDiscountAmount);
		setLabDoctorFeeDiscountAmount(doctorFeeDiscountAmount);
		setLabDoctorFee(labDoctorFee);
		setTicketItemAdjustedDiscount(ticketItem.getAdjustedDiscount());

		double labDoctoreFeeDueAmount = labDoctorFee - ticketItem.getLabDoctorFeePaidAmount();
		setLabDoctorFeeDueAmount(labDoctoreFeeDueAmount);

		if (ticketItem.isComboItem()) {
			Double totalAmount = 0d;
			List<TicketItem> comboItems = ticketItem.getComboItems();
			if (comboItems != null && !comboItems.isEmpty()) {
				for (TicketItem comboChild : comboItems) {
					if (ProductType.match(comboChild.getProductType(), ProductType.GOODS)
							|| ProductType.match(comboChild.getProductType(), ProductType.SURGICAL_EQUIPMENT)
							|| ProductType.match(comboChild.getProductType(), ProductType.GENERAL_EQUIPMENT)) {
						totalAmount += comboChild.getTotalAmount();
					}
				}
			}
			setConsumableItemAmount(totalAmount);
		}

		Customer customer = ticket.getCustomer();
		if (customer != null) {
			setPatientName(customer.getName());
			setPatientId(customer.getId());
		}
		calculateNetSale();
	}

	private void calculateNetSale() {
		setOthersAmount(grossSaleAmount - Math.abs(ticketItemAdjustedDiscount) - labDoctorFee - getConsumableItemAmount());

	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String id) {
		this.orderId = id;
	}

	public String getLabDoctorId() {
		return labDoctorId;
	}

	public void setLabDoctorId(String labDoctorId) {
		this.labDoctorId = labDoctorId;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public String getOrderDateDisplay() {
		return DateUtil.formatAsShortDate(DateUtil.convertServerTimeToBrowserTime(getOrderDate()));
	}

	public void setOrderDateDisplay(String orderDateDisplay) {
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getTestName() {
		return testName;
	}

	public void setTestName(String testName) {
		this.testName = testName;
	}

	public String getLabDoctorName() {
		return labDoctorName;
	}

	public void setLabDoctorName(String labDoctorName) {
		this.labDoctorName = labDoctorName;
	}

	public double getLabDoctorFee() {
		return labDoctorFee;
	}

	public void setLabDoctorFee(double labDoctorFee) {
		this.labDoctorFee = labDoctorFee;
	}

	public String getLabDoctorDepartment() {
		return labDoctorDepartment;
	}

	public void setLabDoctorDepartment(String labDoctorDepartment) {
		this.labDoctorDepartment = labDoctorDepartment;
	}

	public String getLabDoctorPhone() {
		return labDoctorPhone;
	}

	public void setLabDoctorPhone(String labDoctorPhone) {
		this.labDoctorPhone = labDoctorPhone;
	}

	public double getLabDoctorFeePaidAmount() {
		return labDoctorFeePaidAmount;
	}

	public void setLabDoctorFeePaidAmount(double labDoctorFeePaidAmount) {
		this.labDoctorFeePaidAmount = labDoctorFeePaidAmount;
	}

	public double getLabDoctorFeeDueAmount() {
		return labDoctorFeeDueAmount;
	}

	public void setLabDoctorFeeDueAmount(double labDoctorFeeDueAmount) {
		this.labDoctorFeeDueAmount = labDoctorFeeDueAmount;
	}

	public double getLabDoctorFeeDiscountAmount() {
		return labDoctorFeeDiscountAmount;
	}

	public void setLabDoctorFeeDiscountAmount(double labDoctorFeeDiscountAmount) {
		this.labDoctorFeeDiscountAmount = labDoctorFeeDiscountAmount;
	}

	public boolean isRevisitFeeApplicable() {
		return isRevisitFeeApplicable;
	}

	public void setRevisitFeeApplicable(boolean isRevisitFeeApplicable) {
		this.isRevisitFeeApplicable = isRevisitFeeApplicable;
	}

	public int getOldTicketCount() {
		return oldTicketCount;
	}

	public void setOldTicketCount(int oldTicket) {
		this.oldTicketCount = oldTicket;
	}

	public int getNewTicketCount() {
		return newTicketCount;
	}

	public void setNewTicketCount(int newTicket) {
		this.newTicketCount = newTicket;
	}

	public double getLabDoctorFeeSubtotal() {
		return labDoctorFeeSubtotal;
	}

	public void setLabDoctorFeeSubtotal(double labDoctorFeeSubtotal) {
		this.labDoctorFeeSubtotal = labDoctorFeeSubtotal;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public String getServiceType() {
		return serviceType;
	}

	public void setServiceType(String serviceType) {
		this.serviceType = serviceType;
	}

	public String getMenuItemId() {
		return menuItemId;
	}

	public void setMenuItemId(String menuItemId) {
		this.menuItemId = menuItemId;
	}

	public double getGrossSaleAmount() {
		return grossSaleAmount;
	}

	public void setGrossSaleAmount(double grossSaleAmount) {
		this.grossSaleAmount = grossSaleAmount;
	}

	public String getProductType() {
		return productType;
	}

	public void setProductType(String productType) {
		this.productType = productType;
	}

	public double getOthersAmount() {
		return othersAmount;
	}

	public void setOthersAmount(double othersAmount) {
		this.othersAmount = othersAmount;
	}

	public double getConsumableItemAmount() {
		return consumableItemAmount;
	}

	public void setConsumableItemAmount(double consumableItemAmount) {
		this.consumableItemAmount = consumableItemAmount;
	}

	public double getTicketItemAdjustedDiscount() {
		return ticketItemAdjustedDiscount;
	}

	public void setTicketItemAdjustedDiscount(double ticketItemDiscount) {
		this.ticketItemAdjustedDiscount = ticketItemDiscount;
	}

}
