package com.floreantpos.util;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.dao.SequenceNumberDAO;

public class OutdoorTicketTokenNumberGenerator {

	public static int generateTokenNo(Outlet outlet, String doctorId) {
		String date = SequenceNumber.yearMonthDayFormat.format(new Date());

		String tokenKey = SequenceNumber.OUTDOOR_TICKET_TOKEN + "_" + outlet.getId();

		if (outlet.isEnableSeparateSerialForDoctor()) {
			if (StringUtils.isNotBlank(doctorId)) {
				tokenKey = tokenKey + "_" + doctorId;
			}
		}

		return SequenceNumberDAO.getInstance().getNextSequenceNumber(tokenKey, date);
	}
}
