package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseBloodInventory;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.util.NumberUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class BloodInventory extends BaseBloodInventory implements PropertyContainer2, TimedModel {
	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public BloodInventory() {
		setCreateDate(StoreDAO.getServerTimestamp());
	}

	/**
	 * Constructor for primary key
	 */
	public BloodInventory(java.lang.String id) {
		super(id);
		setCreateDate(StoreDAO.getServerTimestamp());
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public String getQuantityDisplay() {
		Integer qty = getQuantity();
		return qty + " Bag";
	}

	public String getVolumeDisplay() {
		String volumeDisplay = StringUtils.EMPTY;
		Double volume = getVolume();
		if (volume > 0) {
			volumeDisplay = NumberUtil.formatNumberIfNeeded(volume);
		}
		String unit = getUnit();
		if (StringUtils.isNotBlank(unit)) {
			volumeDisplay += " " + unit;
		}

		return volumeDisplay;
	}

	public String bloodGroupDisplay() {
		String bloodGroup = getBloodGroup();
		if (StringUtils.isNotBlank(bloodGroup)) {
			return BloodGroupType.valueOf(bloodGroup).getDisplayString();
		}
		return StringUtils.EMPTY;
	}

}