package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MED_OUTDOOR_DOCTOR_PROFILE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MED_OUTDOOR_DOCTOR_PROFILE"
 */

public abstract class BaseOutdoorDoctorProfile  implements Serializable {

	public static String REF = "OutdoorDoctorProfile"; //$NON-NLS-1$
	public static String PROP_DOCTOR_NAME = "doctorName"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_CHARGE_RATE = "doctorChargeRate"; //$NON-NLS-1$
	public static String PROP_OUTDOOR_FEE = "outdoorFee"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_CHARGE_TYPE = "doctorChargeType"; //$NON-NLS-1$
	public static String PROP_REVISIT_DURATION_TYPE = "revisitDurationType"; //$NON-NLS-1$
	public static String PROP_ACTIVE = "active"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_REVISIT_FEE = "revisitFee"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_REVISIT_INTERVAL = "revisitInterval"; //$NON-NLS-1$


	// constructors
	public BaseOutdoorDoctorProfile () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseOutdoorDoctorProfile (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String outletId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String doctorId;
				private java.lang.String doctorName;
				private java.lang.Double outdoorFee;
				private java.lang.Double revisitFee;
				private java.lang.Double doctorChargeRate;
				private java.lang.String doctorChargeType;
				private java.lang.Integer revisitInterval;
				private java.lang.String revisitDurationType;
				private java.lang.Boolean active;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_NAME
	 */

	public java.lang.String getDoctorName () {
			return doctorName;
	}



	/**
	 * Set the value related to the column: DOCTOR_NAME
	 * @param doctorName the DOCTOR_NAME value
	 */
			public void setDoctorName (java.lang.String doctorName) {
			this.doctorName = doctorName;
	}



	/**
	 * Return the value associated with the column: OUTDOOR_FEE
	 */

	public java.lang.Double getOutdoorFee () {
						return outdoorFee == null ? Double.valueOf(0) : outdoorFee;
		}



	/**
	 * Set the value related to the column: OUTDOOR_FEE
	 * @param outdoorFee the OUTDOOR_FEE value
	 */
			public void setOutdoorFee (java.lang.Double outdoorFee) {
			this.outdoorFee = outdoorFee;
	}



	/**
	 * Return the value associated with the column: REVISIT_FEE
	 */

	public java.lang.Double getRevisitFee () {
						return revisitFee == null ? Double.valueOf(0) : revisitFee;
		}



	/**
	 * Set the value related to the column: REVISIT_FEE
	 * @param revisitFee the REVISIT_FEE value
	 */
			public void setRevisitFee (java.lang.Double revisitFee) {
			this.revisitFee = revisitFee;
	}



	/**
	 * Return the value associated with the column: DOCTOR_CHARGE_RATE
	 */

	public java.lang.Double getDoctorChargeRate () {
						return doctorChargeRate == null ? Double.valueOf(0) : doctorChargeRate;
		}



	/**
	 * Set the value related to the column: DOCTOR_CHARGE_RATE
	 * @param doctorChargeRate the DOCTOR_CHARGE_RATE value
	 */
			public void setDoctorChargeRate (java.lang.Double doctorChargeRate) {
			this.doctorChargeRate = doctorChargeRate;
	}



	/**
	 * Return the value associated with the column: DOCTOR_CHARGE_TYPE
	 */

	public java.lang.String getDoctorChargeType () {
			return doctorChargeType;
	}



	/**
	 * Set the value related to the column: DOCTOR_CHARGE_TYPE
	 * @param doctorChargeType the DOCTOR_CHARGE_TYPE value
	 */
			public void setDoctorChargeType (java.lang.String doctorChargeType) {
			this.doctorChargeType = doctorChargeType;
	}



	/**
	 * Return the value associated with the column: REVISIT_INTERVAL
	 */

	public java.lang.Integer getRevisitInterval () {
						return revisitInterval == null ? Integer.valueOf(0) : revisitInterval;
		}



	/**
	 * Set the value related to the column: REVISIT_INTERVAL
	 * @param revisitInterval the REVISIT_INTERVAL value
	 */
			public void setRevisitInterval (java.lang.Integer revisitInterval) {
			this.revisitInterval = revisitInterval;
	}



	/**
	 * Return the value associated with the column: REVISIT_DURATION_TYPE
	 */

	public java.lang.String getRevisitDurationType () {
			return revisitDurationType;
	}



	/**
	 * Set the value related to the column: REVISIT_DURATION_TYPE
	 * @param revisitDurationType the REVISIT_DURATION_TYPE value
	 */
			public void setRevisitDurationType (java.lang.String revisitDurationType) {
			this.revisitDurationType = revisitDurationType;
	}



	/**
	 * Return the value associated with the column: ACTIVE
	 */

	public java.lang.Boolean isActive () {
						return active == null ? Boolean.valueOf(true) : active;
			}

	public java.lang.Boolean getActive () {
					return active == null ? Boolean.valueOf(true) : active;
			}


	/**
	 * Set the value related to the column: ACTIVE
	 * @param active the ACTIVE value
	 */
			public void setActive (java.lang.Boolean active) {
			this.active = active;
	}


	/**
	 * Custom property
	 */
	public static String getActiveDefaultValue () {
		return "true";
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.OutdoorDoctorProfile)) return false;
		else {
			com.floreantpos.model.OutdoorDoctorProfile outdoorDoctorProfile = (com.floreantpos.model.OutdoorDoctorProfile) obj;
			if (null == this.getId() || null == outdoorDoctorProfile.getId()) return this == obj;
			else return (this.getId().equals(outdoorDoctorProfile.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}