package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PRESCRIPTION_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PRESCRIPTION_ITEM"
 */

public abstract class BasePrescriptionItem  implements Comparable, Serializable {

	public static String REF = "PrescriptionItem"; //$NON-NLS-1$
	public static String PROP_GROUP_NAME = "groupName"; //$NON-NLS-1$
	public static String PROP_CATEGORY_ID = "categoryId"; //$NON-NLS-1$
	public static String PROP_VAT_AMOUNT = "vatAmount"; //$NON-NLS-1$
	public static String PROP_PRESCRIPTION = "prescription"; //$NON-NLS-1$
	public static String PROP_SUBTOTAL_AMOUNT = "subtotalAmount"; //$NON-NLS-1$
	public static String PROP_ITEM_UNIT_NAME = "itemUnitName"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_TOTAL_COST = "totalCost"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_UNIT_TYPE = "unitType"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_TAX_EXEMPT_AMOUNT = "taxExemptAmount"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_PRODUCT_TYPE = "productType"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public static String PROP_VAT_RATE = "vatRate"; //$NON-NLS-1$
	public static String PROP_GROUP_ID = "groupId"; //$NON-NLS-1$
	public static String PROP_UNIT_COST = "unitCost"; //$NON-NLS-1$
	public static String PROP_TAX_EXEMPT = "taxExempt"; //$NON-NLS-1$
	public static String PROP_UNIT_PRICE = "unitPrice"; //$NON-NLS-1$
	public static String PROP_ITEM_QUANTITY = "itemQuantity"; //$NON-NLS-1$
	public static String PROP_NOTE = "note"; //$NON-NLS-1$
	public static String PROP_CATEGORY_NAME = "categoryName"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BasePrescriptionItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePrescriptionItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BasePrescriptionItem (
		java.lang.String id,
		com.floreantpos.model.Prescription prescription) {

		this.setId(id);
		this.setPrescription(prescription);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String menuItemId;
				private java.lang.Double itemQuantity;
				private java.lang.String name;
				private java.lang.String itemUnitName;
				private java.lang.String unitType;
				private java.lang.String productType;
				private java.lang.String groupId;
				private java.lang.String groupName;
				private java.lang.String categoryId;
				private java.lang.String categoryName;
				private java.lang.Double unitPrice;
				private java.lang.Double unitCost;
				private java.lang.Double totalCost;
				private java.lang.Double subtotalAmount;
				private java.lang.Double discountAmount;
				private java.lang.Double taxAmount;
				private java.lang.Boolean taxExempt;
				private java.lang.Double taxExemptAmount;
				private java.lang.Double vatAmount;
				private java.lang.Double vatRate;
				private java.lang.Double totalAmount;
				private java.lang.String status;
				private java.lang.String note;
				private java.lang.String properties;
	
	// many to one
	private com.floreantpos.model.Prescription prescription;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: ITEM_QUANTITY
	 */

	public java.lang.Double getItemQuantity () {
						return itemQuantity == null ? Double.valueOf(0) : itemQuantity;
		}



	/**
	 * Set the value related to the column: ITEM_QUANTITY
	 * @param itemQuantity the ITEM_QUANTITY value
	 */
			public void setItemQuantity (java.lang.Double itemQuantity) {
			this.itemQuantity = itemQuantity;
	}



	/**
	 * Return the value associated with the column: ITEM_NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: ITEM_NAME
	 * @param name the ITEM_NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: ITEM_UNIT_NAME
	 */

	public java.lang.String getItemUnitName () {
			return itemUnitName;
	}



	/**
	 * Set the value related to the column: ITEM_UNIT_NAME
	 * @param itemUnitName the ITEM_UNIT_NAME value
	 */
			public void setItemUnitName (java.lang.String itemUnitName) {
			this.itemUnitName = itemUnitName;
	}



	/**
	 * Return the value associated with the column: UNIT_TYPE
	 */

	public java.lang.String getUnitType () {
			return unitType;
	}



	/**
	 * Set the value related to the column: UNIT_TYPE
	 * @param unitType the UNIT_TYPE value
	 */
			public void setUnitType (java.lang.String unitType) {
			this.unitType = unitType;
	}



	/**
	 * Return the value associated with the column: PRODUCT_TYPE
	 */

	public java.lang.String getProductType () {
			return productType;
	}



	/**
	 * Set the value related to the column: PRODUCT_TYPE
	 * @param productType the PRODUCT_TYPE value
	 */
			public void setProductType (java.lang.String productType) {
			this.productType = productType;
	}



	/**
	 * Return the value associated with the column: GROUP_ID
	 */

	public java.lang.String getGroupId () {
			return groupId;
	}



	/**
	 * Set the value related to the column: GROUP_ID
	 * @param groupId the GROUP_ID value
	 */
			public void setGroupId (java.lang.String groupId) {
			this.groupId = groupId;
	}



	/**
	 * Return the value associated with the column: GROUP_NAME
	 */

	public java.lang.String getGroupName () {
			return groupName;
	}



	/**
	 * Set the value related to the column: GROUP_NAME
	 * @param groupName the GROUP_NAME value
	 */
			public void setGroupName (java.lang.String groupName) {
			this.groupName = groupName;
	}



	/**
	 * Return the value associated with the column: CATEGORY_ID
	 */

	public java.lang.String getCategoryId () {
			return categoryId;
	}



	/**
	 * Set the value related to the column: CATEGORY_ID
	 * @param categoryId the CATEGORY_ID value
	 */
			public void setCategoryId (java.lang.String categoryId) {
			this.categoryId = categoryId;
	}



	/**
	 * Return the value associated with the column: CATEGORY_NAME
	 */

	public java.lang.String getCategoryName () {
			return categoryName;
	}



	/**
	 * Set the value related to the column: CATEGORY_NAME
	 * @param categoryName the CATEGORY_NAME value
	 */
			public void setCategoryName (java.lang.String categoryName) {
			this.categoryName = categoryName;
	}



	/**
	 * Return the value associated with the column: UNIT_PRICE
	 */

	public java.lang.Double getUnitPrice () {
						return unitPrice == null ? Double.valueOf(0) : unitPrice;
		}



	/**
	 * Set the value related to the column: UNIT_PRICE
	 * @param unitPrice the UNIT_PRICE value
	 */
			public void setUnitPrice (java.lang.Double unitPrice) {
			this.unitPrice = unitPrice;
	}



	/**
	 * Return the value associated with the column: UNIT_COST
	 */

	public java.lang.Double getUnitCost () {
						return unitCost == null ? Double.valueOf(0) : unitCost;
		}



	/**
	 * Set the value related to the column: UNIT_COST
	 * @param unitCost the UNIT_COST value
	 */
			public void setUnitCost (java.lang.Double unitCost) {
			this.unitCost = unitCost;
	}



	/**
	 * Return the value associated with the column: TOTAL_COST
	 */

	public java.lang.Double getTotalCost () {
						return totalCost == null ? Double.valueOf(0) : totalCost;
		}



	/**
	 * Set the value related to the column: TOTAL_COST
	 * @param totalCost the TOTAL_COST value
	 */
			public void setTotalCost (java.lang.Double totalCost) {
			this.totalCost = totalCost;
	}



	/**
	 * Return the value associated with the column: SUB_TOTAL
	 */

	public java.lang.Double getSubtotalAmount () {
						return subtotalAmount == null ? Double.valueOf(0) : subtotalAmount;
		}



	/**
	 * Set the value related to the column: SUB_TOTAL
	 * @param subtotalAmount the SUB_TOTAL value
	 */
			public void setSubtotalAmount (java.lang.Double subtotalAmount) {
			this.subtotalAmount = subtotalAmount;
	}



	/**
	 * Return the value associated with the column: DISCOUNT
	 */

	public java.lang.Double getDiscountAmount () {
						return discountAmount == null ? Double.valueOf(0) : discountAmount;
		}



	/**
	 * Set the value related to the column: DISCOUNT
	 * @param discountAmount the DISCOUNT value
	 */
			public void setDiscountAmount (java.lang.Double discountAmount) {
			this.discountAmount = discountAmount;
	}



	/**
	 * Return the value associated with the column: TAX_AMOUNT
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TAX_AMOUNT
	 * @param taxAmount the TAX_AMOUNT value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: TAX_EXEMPT
	 */

	public java.lang.Boolean isTaxExempt () {
					return taxExempt == null ? Boolean.FALSE : taxExempt;
		}

	public java.lang.Boolean getTaxExempt () {
				return taxExempt == null ? Boolean.FALSE : taxExempt;
			}


	/**
	 * Set the value related to the column: TAX_EXEMPT
	 * @param taxExempt the TAX_EXEMPT value
	 */
			public void setTaxExempt (java.lang.Boolean taxExempt) {
			this.taxExempt = taxExempt;
	}



	/**
	 * Return the value associated with the column: TAX_EXEMPT_AMOUNT
	 */

	public java.lang.Double getTaxExemptAmount () {
						return taxExemptAmount == null ? Double.valueOf(0) : taxExemptAmount;
		}



	/**
	 * Set the value related to the column: TAX_EXEMPT_AMOUNT
	 * @param taxExemptAmount the TAX_EXEMPT_AMOUNT value
	 */
			public void setTaxExemptAmount (java.lang.Double taxExemptAmount) {
			this.taxExemptAmount = taxExemptAmount;
	}



	/**
	 * Return the value associated with the column: VAT_AMOUNT
	 */

	public java.lang.Double getVatAmount () {
						return vatAmount == null ? Double.valueOf(0) : vatAmount;
		}



	/**
	 * Set the value related to the column: VAT_AMOUNT
	 * @param vatAmount the VAT_AMOUNT value
	 */
			public void setVatAmount (java.lang.Double vatAmount) {
			this.vatAmount = vatAmount;
	}



	/**
	 * Return the value associated with the column: VAT_RATE
	 */

	public java.lang.Double getVatRate () {
						return vatRate == null ? Double.valueOf(0) : vatRate;
		}



	/**
	 * Set the value related to the column: VAT_RATE
	 * @param vatRate the VAT_RATE value
	 */
			public void setVatRate (java.lang.Double vatRate) {
			this.vatRate = vatRate;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalAmount () {
						return totalAmount == null ? Double.valueOf(0) : totalAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalAmount the TOTAL_PRICE value
	 */
			public void setTotalAmount (java.lang.Double totalAmount) {
			this.totalAmount = totalAmount;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: NOTE
	 */

	public java.lang.String getNote () {
			return note;
	}



	/**
	 * Set the value related to the column: NOTE
	 * @param note the NOTE value
	 */
			public void setNote (java.lang.String note) {
			this.note = note;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: PRESCRIPTION_ID
	 */

	public com.floreantpos.model.Prescription getPrescription () {
			return prescription;
	}



	/**
	 * Set the value related to the column: PRESCRIPTION_ID
	 * @param prescription the PRESCRIPTION_ID value
	 */
			public void setPrescription (com.floreantpos.model.Prescription prescription) {
			this.prescription = prescription;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.PrescriptionItem)) return false;
		else {
			com.floreantpos.model.PrescriptionItem prescriptionItem = (com.floreantpos.model.PrescriptionItem) obj;
			if (null == this.getId() || null == prescriptionItem.getId()) return this == obj;
			else return (this.getId().equals(prescriptionItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}